<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.1
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;

$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = $product->get_image_id();
$wrapper_classes   = apply_filters( 'woocommerce_single_product_image_gallery_classes', array(
	'woocommerce-product-gallery',
	'woocommerce-product-gallery--' . ( $product->get_image_id() ? 'with-images' : 'without-images' ),
	'woocommerce-product-gallery--columns-' . absint( $columns ),
	'images',
) );
$attachment_ids = $product->get_gallery_image_ids();
if(has_post_thumbnail()):
    array_unshift($attachment_ids, $post_thumbnail_id);
endif;
?>
<?php if(is_array($attachment_ids) && !empty($attachment_ids)): ?>
<div id="productSlide_<?php echo esc_attr($product->get_id()); ?>" class="carousel slide productSlide" data-ride="carousel">
        <div class="carousel-inner">
            <?php 
                $i = 1;
                foreach($attachment_ids as $tid):
                    $imgs = wp_get_attachment_image_src($tid, 'industing-pro-2');
                    ?>
                    <div class="carousel-item <?php if($i == 1){ echo 'active'; } ?>">
                        <div class="ps_img">
                            <img src="<?php echo esc_url($imgs[0]) ?>" alt="<?php echo esc_attr($product->get_title()); ?>"/>
                        </div>
                    </div>
                    <?php
                    $i++;
                endforeach;
            ?>
        </div>
        <ol class="carousel-indicators clearfix">
            <?php 
            $i = 0;
            foreach($attachment_ids as $tid):
                $imgs = wp_get_attachment_image_src($tid, 'industing-pro-3');
                ?>
            <li data-target="#productSlide_<?php echo esc_attr($product->get_id()); ?>" data-slide-to="<?php echo esc_attr($i); ?>" class="<?php if($i == 0){ echo 'active'; } ?>"><img src="<?php echo esc_url($imgs[0]) ?>" alt="<?php echo get_the_title($product->get_id()); ?>"/></li>
                <?php
                $i++;
            endforeach;
            ?>
        </ol>
        <?php echo industin_product_flash_notice_label('inLeftAlign') ?>
    </div>
<?php else: ?>
<div id="productSlide_<?php echo esc_attr($product->get_id()); ?>" class="carousel slide productSlide" data-ride="carousel">
        <div class="carousel-inner">
            <div class="carousel-item active">
                <div class="ps_img">
                    <img src="http://via.placeholder.com/652x738" alt="<?php echo get_the_title($product->get_id()); ?>"/>
                </div>
            </div>
        </div>
        <ol class="carousel-indicators clearfix">
            <li data-target="#productSlide_<?php echo esc_attr($product->get_id()); ?>" data-slide-to="0" class="active"><img src="http://via.placeholder.com/100x70" alt="<?php echo get_the_title($product->get_id()); ?>"/></li>
        </ol>
    </div>
<?php endif; ?>