<?php
/**
 * Empty cart page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-empty.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

defined( 'ABSPATH' ) || exit; ?>
<section class="commonSection shopSections emptyCartPage">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <?php do_action( 'woocommerce_cart_is_empty' ); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <?php if ( wc_get_page_id( 'shop' ) > 0 ) : ?>
                        <p class="return-to-shop">
                            <a class="ind_btn_2" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
                                <span><?php esc_html_e( 'Return to shop', 'industing' ); ?></span>
                            </a>
                        </p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>