<?php
    $folio_banner_bg = get_theme_mod('folio_banner_bg', '');
    $folio_is_breadcrumb = get_theme_mod('folio_is_breadcrumb', 1);
    $folio_bread_title = get_theme_mod('folio_bread_title', esc_html__('Portfolio', 'industing'));
    $folio_banner_title = get_theme_mod('folio_banner_title', esc_html__('Portfolios', 'industing'));
    
    $bgStyle = '';
    if($folio_banner_bg != ''){
        $bgStyle = 'background-image: url('.$folio_banner_bg.'); background-repeat: no-repeat; background-position: center center; background-size: cover;';
    }
    
    if(defined('FW')){
        $page_is_breadcrumb = fw_get_db_post_option(get_the_ID(), 'page_is_breadcrumb', 1);
        $page_bread_title = fw_get_db_post_option(get_the_ID(), 'page_bread_title', '');
        $page_page_title = fw_get_db_post_option(get_the_ID(), 'page_page_title', '');
        
        $page_banner_bg = fw_get_db_post_option(get_the_ID(), 'page_banner_bg', '');
        $page_banner_bg = (isset($page_banner_bg['url']) && $page_banner_bg['url'] != '') ? $page_banner_bg['url'] : '';

        $folio_banner_title = ($page_page_title != '') ? $page_page_title : $folio_banner_title;
        $folio_bread_title = ($page_bread_title != '') ? $page_bread_title : $folio_bread_title;
        $folio_is_breadcrumb = ($page_is_breadcrumb != '') ? $page_is_breadcrumb : $folio_is_breadcrumb;
        if($page_banner_bg != ''){
            $bgStyle = 'background-image: url('.$page_banner_bg.'); background-repeat: no-repeat; background-attachment: scroll; background-position: center center; background-size: cover; ';
        }
    }
    
    if(is_archive()){
        $folio_banner_title = get_the_archive_title();
        $folio_banner_title = str_replace('Year:', '', $folio_banner_title);
        $folio_banner_title = str_replace('Tag:', '', $folio_banner_title);
        $folio_banner_title = str_replace('Author:', '', $folio_banner_title);
        $folio_banner_title = str_replace('Category:', '', $folio_banner_title);
        
        $folio_bread_title = $folio_banner_title;
    }
?>

<section class="page_banner" style="<?php echo esc_attr($bgStyle) ?>">
    <div class="container">
        <div class="row">
            <div class="col-xl-12 text-center">
                <h2><?php echo esc_html($folio_banner_title); ?></h2>
                <div class="breadcrumbs">
                    <?php if ($folio_is_breadcrumb == 1): ?>
                        <a href="<?php echo esc_url(home_url('/')) ?>"><?php echo esc_html__('Home', 'industing') ?></a><i>|</i><span><?php echo esc_html($folio_bread_title); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>