<?php
/**
 * The template for displaying comments
 */

if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comment_area">
    <?php if ( have_comments() ) : ?>
        <?php
            $comments_number = get_comments_number();
            $comment_title = ($comments_number > 1) ? $comments_number.esc_html__(' Comments', 'industing') : $comments_number.esc_html__(' Comment', 'industing');
        ?>
        <h3><?php echo esc_html($comment_title); ?></h3>
        <ol class="comment_list">
            <?php wp_list_comments(array('short_ping'  => true, 'callback'=> 'industing_comment_listing')); ?>
        </ol>
        <div class="commentPaginations text-right">
            <?php paginate_comments_links( array('prev_text' => '<i class="twi-angle-left2"></i>', 'next_text' => '<i class="twi-angle-right2"></i>') ) ?>
        </div>
        
    <?php endif; ?>
	<?php
        $class = '';
        if(is_user_logged_in())
        {
            $class = 'loggedIns';
        }
        $fields = array(
                    'author' =>'<div class="cfItem"><input id="author" placeholder="'.esc_attr__('Type your name...', 'industing').'" name="author" type="text" value="' .
                                esc_attr( $commenter['comment_author'] ) . '" size="30" /><i class="twi-user-alt2"></i></div>',
            
                    'email'  => '<div class="cfItem"><input id="email" placeholder="'.esc_attr__('Type your email...', 'industing').'" ID" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) .
                                '" size="30" /><i class="twi-envelope2"></i></div>',
                    
                    'url'  => '<div class="cfItem"><input id="url" placeholder="'.esc_attr__('Type your website...', 'industing').'" ID" name="url" type="url" value="' . esc_attr(  $commenter['comment_author_url'] ) .
                                '" size="30" /><i class="twi-globe2"></i></div>',
                    
                );
        
        $fields = apply_filters('comment_form_default_fields', $fields);
        $args = array(
            'fields'               => $fields,
            'comment_field'        => '<div class="cfItem"><textarea id="comment" name="comment"  placeholder="'.esc_attr__('Type your comment...', 'industing').'" aria-required="true" required="required"></textarea><i class="twi-pencil-alt2"></i></div>',
            'logged_in_as'         => '',
            'comment_notes_before' => '',
            'comment_notes_after'  => '',
            'id_form'              => 'commentform',
            'id_submit'            => 'submit',
            'class_form'           => 'commentForm',
            'class_submit'         => '',
            'name_submit'          => 'submit',
            'title_reply'          => esc_html__( 'Post Comment ' , 'industing'),
            'title_reply_to'       => esc_html__( 'Lave a Comment to %s', 'industing'),
            'title_reply_before'   => '<h3 id="reply-title" class="commentTitle">',
            'title_reply_after'    => '</h3>',
            'cancel_reply_before'  => ' <small>',
            'cancel_reply_after'   => '</small>',
            'cancel_reply_link'    => esc_html__( 'Cancel reply' , 'industing'),
            'label_submit'         => esc_html__( 'Submit Comment' , 'industing'),
            'submit_button'        => '<input name="%1$s" value="Post Comment" type="submit" id="%2$s" class="%3$s"/>',
            'submit_field'         => '%1$s %2$s',
        );
    ?>
    <div class="form">
        <?php
            comment_form($args);
        ?>
    </div>
</div>