<?php
/**
 * Creates widget with work post
 */

class Tw_Works_Widgets extends WP_Widget
{
    function __construct() 
    {
        $widget_opt = array(
            'classname'     => 'industing_work_widget',
            'description'   => 'Industing Works Post'
        );
        
        parent::__construct('industing-work', esc_html__('Industing Works Post', 'themewar'), $widget_opt);
    }
    
    function widget( $args, $instance )
    {
        $title = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__( 'Latest Works', 'themewar' );
        $number_of_posts1 = (isset($instance['number_of_posts1']) && $instance['number_of_posts1'] != '') ? $instance['number_of_posts1'] : 3;
        $ord_by = (isset($instance['ord_by']) && $instance['ord_by'] != '') ? $instance['ord_by'] : 'date';
        $ord = (isset($instance['ord']) && $instance['ord'] != '') ? $instance['ord'] : 'DESC';
        
        
        $title = apply_filters( 'widget_title', $title );
        echo wp_kses_post($args['before_widget']);
        if ( ! empty( $title ) )
        {
            echo wp_kses_post($args['before_title']) . esc_html($title) . $args['after_title'];
        }
        
        
        $stickies = get_option( 'sticky_posts' );
        $querys = array(
            'post_type'         => array('folio'),
            'post_status'       => array('publish'),
            'orderby'           => $ord_by,
            'order'             => $ord,
            'posts_per_page'    => $number_of_posts1,
            'post__not_in'      => $stickies
        );
        $tw_query = new WP_Query($querys);
        echo '<div class="allLatestWorks">';
        if($tw_query->have_posts())
        {
            while($tw_query->have_posts()): $tw_query->the_post();
            
            $terms = get_the_terms(get_the_ID(), 'folio_cat');
            $cats = '';
            if (is_array($terms) && !empty($terms)) 
            {
                $p = 1;
                $c = count($terms);
                foreach ($terms as $term) 
                {
                    if($p == $c)
                    {
                        $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                    }
                    else
                    {
                        $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a> / ';
                    }
                    $p++;
                }
            }
            ?>
            <div class="ltworks">
                <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo substr(wp_kses(get_the_title(), array()), 0, 30) ?></a></h3>
                <p><?php echo wp_kses_post($cats); ?></p>
            </div>
            <?php
            endwhile;
        }
        else
        {
            echo '<div class="ltworks">';
            echo '<h6><a href="#">No post found to display.</a></h6>';
            echo '</div>';
            echo '<div class="clearfix"></div>';
        }
        echo '</div>';
        wp_reset_postdata();
        
        echo wp_kses_post($args['after_widget']);
    }
    
    
    function update ( $new_instance, $old_instance ) 
    {
        return $new_instance;
    }
    
    function form($instance)
    {
        $title = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__( 'Latest Works', 'themewar' );
        $number_of_posts1 = (isset($instance['number_of_posts1']) && $instance['number_of_posts1'] != '') ? $instance['number_of_posts1'] : 3;
        $ord_by = (isset($instance['ord_by']) && $instance['ord_by'] != '') ? $instance['ord_by'] : 'date';
        $ord = (isset($instance['ord']) && $instance['ord'] != '') ? $instance['ord'] : 'DESC';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e( 'Title:', 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'number_of_posts1' )); ?>"><?php _e( 'Number Of Posts:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'number_of_posts1' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number_of_posts1' )); ?>" type="text" value="<?php echo esc_attr( $number_of_posts1 ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'ord_by' )); ?>"><?php _e( 'Order By:' , 'themewar' ); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'ord_by' )); ?>" name="<?php echo esc_attr($this->get_field_id( 'ord_by' )); ?>">
                <option value="date" <?php if($ord_by == 'date'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Date', 'themewar'); ?></option>
                <option value="ID" <?php if($ord_by == 'ID'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('ID', 'themewar'); ?></option>
                <option value="title" <?php if($ord_by == 'title'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Title', 'themewar'); ?></option>
                <option value="rand" <?php if($ord_by == 'rand'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Random', 'themewar'); ?></option>
                <option value="comment_count" <?php if($ord_by == 'comment_count'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Comment Count', 'themewar'); ?></option>
            </select>
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'ord' )); ?>"><?php _e( 'Order:' , 'themewar' ); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'ord' )); ?>" name="<?php echo esc_attr($this->get_field_id( 'ord' )); ?>">
                <option value="ASC" <?php if($ord == 'ASC'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('ASC', 'themewar'); ?></option>
                <option value="DESC" <?php if($ord == 'DESC'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('DESC', 'themewar'); ?></option>
            </select>
	</p>
        
        <?php
    }
}