<?php
if (!defined('ABSPATH')) die('Direct access forbidden.');

class Tw_Users_Meta_Hooks
{
    public function __construct()
    {
        add_action('show_user_profile', array($this, 'tw_user_avater'));
        add_action('edit_user_profile', array($this, 'tw_user_avater'));
        add_action('personal_options_update', array($this, 'tw_user_avatar_src'));
        add_action('edit_user_profile_update', array($this, 'tw_user_avatar_src'));
    }

    public function tw_user_avater($user)
    {
        $user_facebook = get_the_author_meta('user_facebook', $user->ID);
        $user_twitter = get_the_author_meta('user_twitter', $user->ID);
        $user_behanced = get_the_author_meta('user_behanced', $user->ID);
        $user_youtube = get_the_author_meta('user_youtube', $user->ID);
        $user_linkedin = get_the_author_meta('user_linkedin', $user->ID);
        $user_tumblr = get_the_author_meta('user_tumblr', $user->ID);
        $user_pinterest = get_the_author_meta('user_pinterest', $user->ID);
        $user_instagram = get_the_author_meta('user_instagram', $user->ID);
        
        
        ?>
        
        <table class="form-table">
            <tr>
                <th><h3>User Avatar</h3></th>
                <td>
                    <?php
                    $avater_src = get_the_author_meta('user_avatar', $user->ID);
                    $user_av_ID = get_the_author_meta('user_av_ID', $user->ID);
                    if ($avater_src != '') {
                        $av = $avater_src;
                        $vis = 'block';
                    } else {
                        $av = '';
                        $vis = 'none';
                    }
                    ?>
                    <img class="user_logo upImg" src="<?php echo esc_url($av); ?>" height="100" width="100"
                         style="display: <?php echo esc_attr($vis); ?>;"/>
                    <div class="clear"></div>
                    <input type="text" name="user_avatar" value="<?php echo esc_url($av); ?>"
                           class="regular-text user_avater_url"/>
                    <input type="hidden" name="user_av_ID" value="<?php echo esc_attr($user_av_ID); ?>"
                           id="user_av_ID"/>
                    <a href="#" class="useravatar_upload button">Upload</a>
                </td>
            </tr>
            <tr>
                <td>
                    <h3>Facebook</h3>
                </td>
                <td>
                    <input type="url" name="user_facebook" value="<?php echo esc_attr($user_facebook); ?>" class="regular-text">
                </td>
            </tr>
            <tr>
                <td>
                    <h3>Twitter</h3>
                </td>
                <td>
                    <input type="url" name="user_twitter" value="<?php echo esc_attr($user_twitter); ?>" class="regular-text">
                </td>
            </tr>
            <tr>
                <td>
                    <h3>Behanced</h3>
                </td>
                <td>
                    <input type="url" name="user_behanced" value="<?php echo esc_attr($user_behanced); ?>" class="regular-text">
                </td>
            </tr>
            <tr>
                <td>
                    <h3>Youtube</h3>
                </td>
                <td>
                    <input type="url" name="user_youtube" value="<?php echo esc_attr($user_youtube); ?>" class="regular-text">
                </td>
            </tr>
            <tr>
                <td>
                    <h3>Linkedin</h3>
                </td>
                <td>
                    <input type="url" name="user_linkedin" value="<?php echo esc_attr($user_linkedin); ?>" class="regular-text">
                </td>
            </tr>
            <tr>
                <td>
                    <h3>Tumblr</h3>
                </td>
                <td>
                    <input type="url" name="user_tumblr" value="<?php echo esc_attr($user_tumblr); ?>" class="regular-text">
                </td>
            </tr>
            <tr>
                <td>
                    <h3>Pinterest</h3>
                </td>
                <td>
                    <input type="url" name="user_pinterest" value="<?php echo esc_attr($user_pinterest); ?>" class="regular-text">
                </td>
            </tr>
            <tr>
                <td>
                    <h3>Instagram</h3>
                </td>
                <td>
                    <input type="url" name="user_instagram" value="<?php echo esc_attr($user_instagram); ?>" class="regular-text">
                </td>
            </tr>
        </table>
        <?php
    }

    function tw_user_avatar_src($user_id)
    {
        update_user_meta($user_id, 'user_avatar', sanitize_text_field($_POST['user_avatar']));
        update_user_meta($user_id, 'user_av_ID', sanitize_text_field($_POST['user_av_ID']));
        update_user_meta($user_id, 'user_facebook', sanitize_text_field($_POST['user_facebook']));
        update_user_meta($user_id, 'user_twitter', sanitize_text_field($_POST['user_twitter']));
        update_user_meta($user_id, 'user_behanced', sanitize_text_field($_POST['user_behanced']));
        update_user_meta($user_id, 'user_youtube', sanitize_text_field($_POST['user_youtube']));
        update_user_meta($user_id, 'user_linkedin', sanitize_text_field($_POST['user_linkedin']));
        update_user_meta($user_id, 'user_tumblr', sanitize_text_field($_POST['user_tumblr']));
        update_user_meta($user_id, 'user_pinterest', sanitize_text_field($_POST['user_pinterest']));
        update_user_meta($user_id, 'user_instagram', sanitize_text_field($_POST['user_instagram']));
    }
}

?>