<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Text_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-heading';
    }

    public function get_title() {
        return esc_html__( 'Industing Text', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-text';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label'     => esc_html__( 'Industing Text', 'themewar' ),
            ]
        );
        $this->add_control(
                'is_lead_p',
                [
                        'label' => esc_html__( 'Is Lead', 'themewar' ),
                        'type' => Controls_Manager::SWITCHER,
                        'label_on' => esc_html__( 'Yes', 'themewar' ),
                        'label_off' => esc_html__( 'No', 'themewar' ),
                        'return_value' => '1',
                        'default' => '2',
                ]
        );
        $this->add_control(
            'heading_text', [
                'label'         => esc_html__( 'Text', 'themewar' ),
                'type'		=> Controls_Manager::TEXTAREA,
                'label_block'	=> true,
                'placeholder'	=> esc_html__( 'Add Text', 'themewar' ),
                'default'	=> '',
            ]
        );
        $this->add_responsive_control(
            'text_align', [
                'label'			=>esc_html__( 'Alignment', 'themewar' ),
                'type'			=> Controls_Manager::CHOOSE,
                'options'		=> [

                    'left'		=> [
                        'title'         =>esc_html__( 'Left', 'themewar' ),
                        'icon'          => 'fa fa-align-left',
                    ],
                    'center'            => [
                        'title'         =>esc_html__( 'Center', 'themewar' ),
                        'icon'          => 'fa fa-align-center',
                    ],
                    'right'		=> [
                        'title'         =>esc_html__( 'Right', 'themewar' ),
                        'icon'          => 'fa fa-align-right',
                    ],
                ],
                'default'		=> 'left',
                'prefix_class'          => 'text_align elementor%s-align-',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'heading_style', [
                'label'	 =>esc_html__( 'Text Style', 'themewar' ),
                'tab'	 => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'heading_color', [
                'label'		 =>esc_html__( 'Text color', 'themewar' ),
                'type'		 => Controls_Manager::COLOR,
                'selectors'	 => [
                    '{{WRAPPER}} .ind_ps' => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'		 => 'heading_typography',
                'selector'	 => '{{WRAPPER}} .ind_ps',
            ]
        );
        $this->add_control(
                'paddings',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .ind_ps' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'margins',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .ind_ps' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
    }

    protected function render() {
        $settings       = $this->get_settings();
        $heading_text   = (isset($settings['heading_text']) && $settings['heading_text'] != '') ? $settings['heading_text'] : '';
        $is_lead_p   = (isset($settings['is_lead_p']) && $settings['is_lead_p'] != '') ? $settings['is_lead_p'] : 2;
        
        if($heading_text != ''):
            ?>
                <p class="ind_ps <?php if($is_lead_p == 1): ?>ind_lead<?php endif; ?>"><?php echo wp_kses_post($heading_text); ?></p>
            <?php
        endif;
    }

    protected function _content_template() {

    }
}
