<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Team_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-team';
    }
    public function get_title() {
        return esc_html__( 'Team', 'themewar' );
    }
    public function get_icon() {
        return ' eicon-person';
    }
    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'Team Member', 'themewar' ),
            ]
        );
        $this->add_control(
                'team_style',
                [
                        'label'     => esc_html__( 'Team Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 0,
                        'options'   => [
                                0                  => esc_html__( 'Select Style', 'themewar' ),
                                1                  => esc_html__( 'Team Style 01', 'themewar' ),
                                2                  => esc_html__( 'Team Style 02', 'themewar' )
                        ],
                ]
        );
        $this->add_control(
                'styles',
                [
                        'label' => esc_html__( 'View Style', 'themewar' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 0,
                        'options' => [
                                0       => esc_html__( 'Selec Style', 'themewar' ),
                                1       => esc_html__( 'Slider', 'themewar' ),
                                2       => esc_html__( 'Fixed', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'order_by',
                [
                        'label' => esc_html__( 'Order By', 'themewar' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'date',
                        'options' => [
                                'ID'       => esc_html__( 'ID', 'themewar' ),
                                'title'       => esc_html__( 'Title', 'themewar' ),
                                'date'       => esc_html__( 'Date', 'themewar' ),
                                'rand'       => esc_html__( 'Random', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'order',
                [
                        'label' => esc_html__( 'Order', 'themewar' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'DESC',
                        'options' => [
                                'ASC'       => esc_html__( 'Ascending', 'themewar' ),
                                'DESC'       => esc_html__( 'Descending', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'no_of_items',
                [
                        'label' => esc_html__( 'Number of Items', 'themewar' ),
                        'type' => Controls_Manager::NUMBER,
                        'min' => 3,
                        'max' => 100,
                        'step' => 1,
                        'default' => 5,
                ]
        );
        $this->add_responsive_control(
                'team_align', [
                        'label'                     =>esc_html__( 'Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'		 => [
                                        'title'	 =>esc_html__( 'Left', 'themewar' ),
                                        'icon'	 => 'fa fa-align-left',
                                ],
                                'center'	 => [
                                        'title'	 =>esc_html__( 'Center', 'themewar' ),
                                        'icon'	 => 'fa fa-align-center',
                                ],
                                'right'		 => [
                                        'title'	 =>esc_html__( 'Right', 'themewar' ),
                                        'icon'	 => 'fa fa-align-right',
                                ]
                        ],
                        'default'                   => 'center',
                        'prefix_class'              => 'team_align elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_1',[
                    'label'     => esc_html__('Team Inner Bg Style', 'themewar'),
                    'tab'       => Controls_Manager::TAB_STYLE,
                    'condition'     => ['team_style' => '2']
                ]
        );
        $this->add_control(
                'team_bg',
                [
                        'label' => esc_html__( 'Inner BG Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .st2_inner' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
                'inner_padding',
                [
                        'label' => esc_html__( 'Inner Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .st2_inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->add_control(
                'inner_margin',
                [
                        'label' => esc_html__( 'Inner Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .st2_inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2',
            [
                'label'     => esc_html__('Member Name Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'style_tabs_1' );
            $this->start_controls_tab(
                    'title_normal',
                    [
                            'label' => __( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'title_color',
                    [
                            'label' => esc_html__( 'Name Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .singleTeam h3' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .st2_inner h2' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'title_hover',
                    [
                            'label' => __( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'title_hover_color',
                    [
                            'label' => esc_html__( 'Name Hover Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .singleTeam h3 a:hover' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .st2_inner h2 a:hover' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'title_typography',
                        'label' => esc_html__( 'Name Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .singleTeam h3, .st2_inner h2',
                ]
        );
        $this->add_control(
                'title_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .singleTeam h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .st2_inner h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->add_control(
                'title_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .singleTeam h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .st2_inner h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_3',
            [
                'label'     => esc_html__('Member Designation Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
                'desig_color',
                [
                        'label' => esc_html__( 'Designation Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .singleTeam span' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .st2_inner span' => 'color: {{VALUE}}'
                        ],
                ]
        );        
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'desig_typography',
                        'label' => esc_html__( 'Designation Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .singleTeam span',
                        'selector' => '{{WRAPPER}} .st2_inner span'
                ]
        );
        $this->add_control(
                'desig_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .singleTeam span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .st2_inner span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->add_control(
                'desig_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .singleTeam span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .st2_inner span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_4',
            [
                'label'     => esc_html__('Member Description Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'     => ['team_style' => '1']
            ]
        );
        $this->add_control(
                'desc_color',
                [
                        'label' => esc_html__( 'Description Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .singleTeam p' => 'color: {{VALUE}}',
                        ],
                ]
        );        
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'desc_typography',
                        'label' => esc_html__( 'Description Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .singleTeam p',
                ]
        );
        $this->add_control(
                'desc_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .singleTeam p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'desc_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .singleTeam p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_5',
            [
                'label'     => esc_html__('Social Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'     => ['team_style' => '1']
            ]
        );
        $this->start_controls_tabs( 'style_tabs_2' );
            $this->start_controls_tab(
                    'social_normal',
                    [
                            'label' => __( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'social_color',
                    [
                            'label' => esc_html__( 'Social Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .teamsocials a' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'social_hover',
                    [
                            'label' => __( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'social_hover_color',
                    [
                            'label' => esc_html__( 'Social Hover Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .teamsocials a:hover' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'social_typography',
                        'label' => esc_html__( 'Social Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .teamsocials a',
                ]
        );
        $this->add_control(
                'social_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .teamsocials' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'social_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .teamsocials a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_6',
            [
                'label'     => esc_html__('Bullet Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'     => ['team_style' => '1']
            ]
        );
        $this->add_control(
            'b_width',
            [
                    'label' => __( 'Width', 'themewar' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                            'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                    'step' => 1,
                            ],
                            '%' => [
                                    'min' => 0,
                                    'max' => 100,
                            ],
                    ],
                    'default' => [],
                    'selectors' => [
                            '{{WRAPPER}} .teamslider.owl-carousel .owl-dots .owl-dot' => 'width: {{SIZE}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
                'b_height',
                [
                        'label' => __( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .teamslider.owl-carousel .owl-dots .owl-dot' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'style_tabs_3' );
            $this->start_controls_tab(
                    'style_bullet_normal',
                    [
                            'label' => __( 'Normal', 'themewar' ),
                    ]
            );

            $this->add_control(
                    'bullet_normal_color',
                    [
                            'label' => esc_html__( 'BG Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .teamslider.owl-carousel .owl-dots .owl-dot' => 'background: {{VALUE}}',
                            ],
                    ]
            );

            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_bullet_hover',
                    [
                            'label' => __( 'Hover', 'themewar' ),
                    ]
            );

            $this->add_control(
                    'bullet_hover_color',
                    [
                            'label' => esc_html__( 'Hover BG Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .teamslider.owl-carousel .owl-dots .owl-dot:hover'   => 'background: {{VALUE}}',
                                    '{{WRAPPER}} .teamslider.owl-carousel .owl-dots .owl-dot.active'  => 'background: {{VALUE}}'
                            ],
                    ]
            );

            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
                'bullte_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .teamslider.owl-carousel .owl-dots .owl-dot' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_7',
            [
                'label'     => esc_html__('Arrow Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'     => ['team_style' => '2']
            ]
        );
        $this->start_controls_tabs( 'style_tabs_4' );
            $this->start_controls_tab(
                    'style_arrow_normal',
                    [
                            'label' => __( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'arrow_normal_color',
                    [
                            'label' => esc_html__( 'BG Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .teamslider2.owl-carousel .owl-nav button' => 'background: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_control(
                    'arrow_b_normal_color',
                    [
                            'label' => esc_html__( 'Border Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .teamslider2.owl-carousel .owl-nav button' => 'border-color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_control(
                    'arrow_color',[
                            'label' => esc_html__( 'Arrow Icon Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .teamslider2.owl-carousel .owl-nav button' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_arrow_hover',
                    [
                            'label' => __( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'arrow_hover_normal_color',
                    [
                            'label' => esc_html__( 'BG Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .teamslider2.owl-carousel .owl-nav button:hover' => 'background: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_control(
                    'arrow_b_hover_normal_color',
                    [
                            'label' => esc_html__( 'Border Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .teamslider2.owl-carousel .owl-nav button:hover' => 'border-color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_control(
                    'arrow_hover_color',[
                            'label' => esc_html__( 'Arrow Icon Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .teamslider2.owl-carousel .owl-nav button:hover' => 'color: {{VALUE}}',
                            ],
                    ]
            );

            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
                'arrow_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .teamslider2.owl-carousel .owl-nav button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings       = $this->get_settings();
        $styles         = (isset($settings['styles']) && $settings['styles'] > 0) ? $settings['styles'] : 0;
        $team_style     = (isset($settings['team_style']) && $settings['team_style'] > 0) ? $settings['team_style'] : 0;
        $order          = (isset($settings['order']) && $settings['order'] != '') ? $settings['order'] : 'DESC';
        $order_by       = (isset($settings['order_by']) && $settings['order_by'] != '') ? $settings['order_by'] : 'date';
        $no_of_items    = (isset($settings['no_of_items']) && $settings['no_of_items'] > 0) ? $settings['no_of_items'] : 5;
        
        switch ($team_style) {
            case 1:
                require_once dirname(__FILE__).'/style/team/style1.php';
                break;
            case 2:
                require_once dirname(__FILE__).'/style/team/style2.php';
                break;
            default:
                ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo esc_html__('Please Select Team Style first.', 'themewar'); ?>
                    </div>
                <?php
                break;
        }
    }
    
    protected function _content_template() {

    }
}