<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit;

class Tw_Rev_Slider_Widgets extends Widget_Base {

    public function get_name() {
        return 'tw-rev-slider';
    }

    public function get_title() {
        return esc_html__('Rev Slider', 'themewar');
    }

    public function get_icon() {
        return 'eicon-slideshow';
    }

    public function get_categories() {
        return [ 'industing-elements'];
    }

    protected function _register_controls() {
        global $wpdb;
        $table_name = $wpdb->prefix.'revslider_sliders';
        $slides = array('none' => esc_html__('Select Slider', 'themewar'));
        if ( $wpdb->get_var("SHOW TABLES LIKE '$table_name'") == $table_name ) :
            $query = "select r.title, r.id, r.alias from $table_name r";
            $sliders = $wpdb->get_results($query, ARRAY_A);
            if(!empty($sliders)):
                foreach($sliders as $sl):
                    $slides[$sl['alias']] = $sl['title'];
                endforeach;
            endif;
        endif;
        $this->start_controls_section(
                'section_tab_1', [
                    'label' => esc_html__('Rev Slider', 'themewar'),
                ]
        );
        $this->add_control(
                'rev_alise',
                [
                        'label' => esc_html__( 'Select Slider', 'themewar' ),
                        'type' => Controls_Manager::SELECT,
                        'options' => $slides,
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2',
            [
                'label'         => esc_html__('Navigation Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs( 'style_tabs_1' );
        $this->start_controls_tab(
                    'style_normal',
                    [
                            'label'     => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'nav_color',
                    [
                            'label' => esc_html__( 'Navigation Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .rev_slider .tparrows.tp-leftarrow:before'  => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .rev_slider .tparrows.tp-rightarrow:before' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_control(
                    'nav_bg_color',
                    [
                            'label' => esc_html__( 'Navigation BG', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .rev_slider .tp-leftarrow'  => 'background: {{VALUE}}',
                                    '{{WRAPPER}} .rev_slider .tp-rightarrow' => 'background: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_hover',
                    [
                            'label' => __( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'nav_hover_color',
                    [
                            'label' => esc_html__( 'Navigation Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .rev_slider .tparrows.tp-leftarrow:hover:before'  => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .rev_slider .tparrows.tp-rightarrow:hover:before' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_control(
                    'nav_bg_hover_color',
                    [
                            'label' => esc_html__( 'Navigation BG Hover', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .rev_slider .tp-leftarrow:hover'  => 'background: {{VALUE}}',
                                    '{{WRAPPER}} .rev_slider .tp-rightarrow:hover' => 'background: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
                'icon_size',
                [
                        'label' => esc_html__( 'Font Size', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        'default' => [
                                'unit' => 'px',
                                'size' => '',
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .rev_slider .tparrows.tp-leftarrow:before'  => 'font-size: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .rev_slider .tparrows.tp-rightarrow:before' => 'font-size: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'width',
                [
                        'label' => __( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ]
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .rev_slider .tp-leftarrow'  => 'width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .rev_slider .tp-rightarrow' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'height',
                [
                        'label' => __( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ]
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .rev_slider .tp-leftarrow' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .rev_slider .tp-rightarrow' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'padding',
                [
                        'label' => esc_html__( 'Padding', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .rev_slider .tp-leftarrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .rev_slider .tp-rightarrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings       = $this->get_settings_for_display();
        $rev_alise      = (isset($settings['rev_alise']) && $settings['rev_alise'] != '') ? $settings['rev_alise'] : '';
        
        
        if($rev_alise != 'none' && $rev_alise != ''){
            echo do_shortcode('[rev_slider alias="'.$rev_alise.'"]');
        }else{
            echo '<div class="alert alert-warning" role="alert"> <strong>Warning!</strong> Please select a slider from dropdown. </div>';
        }
    }

    protected function _content_template() {
        
    }

}
