<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Product_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-product';
    }
    
    public function get_title() {
        return esc_html__( 'Products', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-post-list';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $product_cat = array(
            'orderby'       => 'ID',
            'order'         => 'DESC', 
            'hide_empty'    => 1,
            'hierarchical'  => 1,
            'taxonomy'      => 'product_cat'
        );
        $categories = get_categories( $product_cat );
        $cats = array( '0' => esc_html__('All Category', 'themewar'));
        if(is_array($categories) && !empty($categories)){
            foreach ($categories as $cat){
                $cats[$cat->term_id] = $cat->name;
            }
        }
        
        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'Product', 'themewar' ),
            ]
        );
        $this->add_control(
                'product_view',
                [
                        'label' => esc_html__( 'View Style', 'themewar' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 0,
                        'options' => [
                                0       => esc_html__( 'Selec Style', 'themewar' ),
                                1       => esc_html__( 'Slider', 'themewar' ),
                                2       => esc_html__( 'Static', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'product_type',
                [
                        'label'         => esc_html__( 'Product Type', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'default'       => 0,
                        'label_block'   => TRUE,
                        'options'       => [
                                0       => esc_html__( 'Select Product Type', 'themewar' ),
                                1       => esc_html__( 'New Product', 'themewar' ),
                                2       => esc_html__( 'Featured Product', 'themewar' ),
                                3       => esc_html__( 'Sale Product', 'themewar' ),
                                4       => esc_html__( 'Popular Product', 'themewar' ),
                                5       => esc_html__( 'Best Seller Product', 'themewar' ),
                                6       => esc_html__( 'Top Rated Product', 'themewar' ),
                                7       => esc_html__( 'Random Product', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'product_cate',
                [
                        'label'     => esc_html__( 'Product Category', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 0,
                        'options'   => $cats
                ]
        );
        $this->add_control(
                'post_item',
                [
                        'label'     => esc_html__( 'Number Of Item', 'themewar' ),
                        'type'      => Controls_Manager::NUMBER,
                        'min'       => 1,
                        'max'       => 100,
                        'step'      => 1,
                        'default'   => 3,
                ]
        );
        
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings       = $this->get_settings();
        $product_view   = (isset($settings['product_view']) && $settings['product_view'] > 0) ? $settings['product_view'] : 0;
        $product_type   = (isset($settings['product_type']) && $settings['product_type'] > 0) ? $settings['product_type'] : 1;
        $product_cate   = (isset($settings['product_cate'])) ? $settings['product_cate'] : 0;
        $post_item      = (isset($settings['post_item']) && $settings['post_item'] > 0) ? $settings['post_item'] : 3;
        
        if($product_view > 0):
            require_once dirname(__FILE__).'/style/product/style1.php';
        else:
            ?>
                <div class="alert alert-warning" role="alert">
                    <?php echo esc_html__('Please select View Style and Product Type first.', 'themewar'); ?>
                </div>
            <?php
        endif;
    }
    
    protected function _content_template() {
        
    }
}