<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Feature_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-feature';
    }
    
    public function get_title() {
        return esc_html__( 'Feature', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-bullet-list';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
                'section_tab_1',
                [
                    'label'             => esc_html__('Single Feature', 'themewar')
                ]
        );
        $this->add_control(
                'feature_style',
                [
                        'label'         => esc_html__( 'Feature Style', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'default'       => 0,
                        'options'       => [
                                0       => esc_html__( 'Select Style', 'themewar' ),
                                1       => esc_html__( 'Slide Feature', 'themewar' ),
                                2       => esc_html__( 'Fixed Feature', 'themewar' ),
                        ],
                ]
        ); 
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
                'img',
                [
                        'label'         => esc_html__( 'Feature Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('Image size should be 370x435px.', 'themewar'),
                ]
        );
        $repeater->add_control(
                'icons',
                [
                        'label'         => esc_html__( 'Box Icon', 'themewar' ),
                        'type'          => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                ]
        );
        $repeater->add_control(
                'title',
                [
                        'label'         => esc_html__( 'Icon Box Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('', 'themewar'),
                        'description'   => esc_html__('Insert your Icon BOx Title.', 'themewar'),
                ]
        );
        $repeater->add_control(
                'title_url',
                [
                        'label'             => esc_html__( 'Title Url', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'show_external'     => true,
                        'default'           => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                        ],
                ]
        );
        $this->add_control(
            'list',
            [
                    'label'   => esc_html__( 'Single Feature', 'themewar' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                            [
                                    'img'                => esc_html__( ' ', 'themewar' ),
                                    'icons'              => esc_html__( '', 'themewar' ),
                                    'title'              => esc_html__( '', 'themewar' ),
                                    'title_url'          => esc_html__( '', 'themewar' ),

                            ],
                    ],
                    'title_field' => '{{{ "Single Feature" }}}',
            ]
        );
        $this->add_responsive_control(
                'box_align', [
                        'label'                  => esc_html__( 'Alignment', 'themewar' ),
                        'type'                   => Controls_Manager::CHOOSE,
                        'options'                => [
                                'left'		 => [
                                        'title'	 => esc_html__( 'Left', 'themewar' ),
                                        'icon'	 => 'fa fa-align-left',
                                ],
                                'center'	 => [
                                        'title'	 => esc_html__( 'Center', 'themewar' ),
                                        'icon'	 => 'fa fa-align-center',
                                ],
                                'right'		 => [
                                        'title'	 => esc_html__( 'Right', 'themewar' ),
                                        'icon'	 => 'fa fa-align-right',
                                ]
                        ],
                        'default'                => 'center',
                        'prefix_class'           => 'f_align elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
                'section_tab_2', [
                    'label'	 => esc_html__( 'Single Feature Style', 'themewar' ),
                    'tab'	 => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_control(
                'overlay',
                [
                        'label' => esc_html__( 'Overlay Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .singleFeature:after' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
                'f_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .singleFeature' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->add_control(
                'f_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .sf_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_3', [
                    'label'	 => esc_html__( 'Icon Style', 'themewar' ),
                    'tab'	 => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_control(
                'icon_color',
                [
                        'label' => esc_html__( 'Icon Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .sf_content i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'icon_typography',
                        'label' => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .sf_content i',
                ]
        );
        $this->add_control(
                'icon_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .sf_content i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
                'section_tab_4', [
                    'label'	 => esc_html__( 'Feature Title Style', 'themewar' ),
                    'tab'	 => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_control(
                'title_color',
                [
                        'label' => esc_html__( 'Title Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .sf_content h3' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
                'title_hover_color',
                [
                        'label' => esc_html__( 'Title Hover Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .sf_content h3 a:hover' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'title_typography',
                        'label' => esc_html__( 'Title Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .sf_content h3',
                ]
        );
        $this->add_control(
                'tilte_margin',
                [
                        'label' => esc_html__( 'Marings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .sf_content h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_5',
            [
                'label'     => esc_html__('Bullet Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control(
            'b_width',
            [
                    'label' => __( 'Width', 'themewar' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                            'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                    'step' => 1,
                            ],
                            '%' => [
                                    'min' => 0,
                                    'max' => 100,
                            ],
                    ],
                    'default' => [],
                    'selectors' => [
                            '{{WRAPPER}} .featureSlider.owl-carousel .owl-dots .owl-dot' => 'width: {{SIZE}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
                'b_height',
                [
                        'label' => __( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .featureSlider.owl-carousel .owl-dots .owl-dot' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'style_tabs_3' );
            $this->start_controls_tab(
                    'style_bullet_normal',
                    [
                            'label' => __( 'Normal', 'themewar' ),
                    ]
            );

            $this->add_control(
                    'bullet_normal_color',
                    [
                            'label' => esc_html__( 'BG Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .featureSlider.owl-carousel .owl-dots .owl-dot' => 'background: {{VALUE}}',
                            ],
                    ]
            );

            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_bullet_hover',
                    [
                            'label' => __( 'Hover', 'themewar' ),
                    ]
            );

            $this->add_control(
                    'bullet_hover_color',
                    [
                            'label' => esc_html__( 'Hover BG Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .featureSlider.owl-carousel .owl-dots .owl-dot:hover'   => 'background: {{VALUE}}',
                                    '{{WRAPPER}} .featureSlider.owl-carousel .owl-dots .owl-dot.active'  => 'background: {{VALUE}}'
                            ],
                    ]
            );

            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
                'bullte_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .featureSlider.owl-carousel .owl-dots .owl-dot' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings       = $this->get_settings();
        $feature_style  = (isset($settings['feature_style']) && $settings['feature_style'] > 0) ? $settings['feature_style'] : 0;
        $feature        = (isset($settings['list']) && !empty($settings['list'])) ? $settings['list'] : array();
        
        switch ($feature_style) {
            case 1:
                if(!empty($feature)):
                    echo '<div class="featureSlider owl-carousel">';
                        foreach($feature as $item):
                            $img        = (isset($item['img']['url'])) ? $item['img']['url'] : 'https://via.placeholder.com/370x435.jpg';
                            $icons      = (isset($item['icons'])) ? $item['icons'] : '';
                            $title      = (isset($item['title'])) ? $item['title'] : '';
                            $t_url      = (isset($item['title_url']['url'])) ? $item['title_url']['url'] : '';
                            ?>
                                <div class="singleFeature">
                                    <?php if($img != ''): ?>
                                        <img src="<?php echo esc_url($img); ?>" alt="">
                                    <?php endif; ?>
                                    <div class="sf_content">
                                        <?php if ($icons != ''): ?>
                                            <i class="<?php echo esc_attr($icons); ?>"></i>
                                        <?php endif; ?>
                                        <?php if($title != ''): ?>
                                            <h3><a href="<?php echo esc_url($t_url); ?>"><?php echo esc_html($title); ?></a></h3>
                                        <?php endif; ?>

                                    </div>
                                </div>
                            <?php
                        endforeach;
                    echo '</div>';
                endif;
                break;
            case 2:
                if(!empty($feature)):
                    echo '<div class="row">';
                    foreach($feature as $item):
                        $img        = (isset($item['img']['url'])) ? $item['img']['url'] : 'https://via.placeholder.com/370x435.jpg';
                        $icons      = (isset($item['icons'])) ? $item['icons'] : '';
                        $title      = (isset($item['title'])) ? $item['title'] : '';
                        $t_url      = (isset($item['title_url']['url'])) ? $item['title_url']['url'] : '';
                        ?>
                        <div class="col-lg-4 col-sm-6">
                            <div class="singleFeature">
                                <?php if($img != ''): ?>
                                    <img src="<?php echo esc_url($img); ?>" alt="">
                                <?php endif; ?>
                                <div class="sf_content">
                                    <?php if ($icons != ''): ?>
                                        <i class="<?php echo esc_attr($icons); ?>"></i>
                                    <?php endif; ?>
                                    <?php if($title != ''): ?>
                                        <h3><a href="<?php echo esc_url($t_url); ?>"><?php echo esc_html($title); ?></a></h3>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                        <?php
                    endforeach;
                    echo '</div>';
                endif;
                break;
            default:
                ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo esc_html__('Please select Feature style first.', 'themewar'); ?>
                    </div>
                <?php
                break;
        }
    }
    
    protected function _content_template() {
        
    }
}