<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Feature_Image_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-feature-image';
    }
    
    public function get_title() {
        return esc_html__( 'Industing Image', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-featured-image';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
                'section_tab_1',
                [
                    'label'     => esc_html__('Image', 'themewar')
                ]
        );
        $this->add_control(
                'img',
                [
                        'label'         => esc_html__( 'Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('Image size should be 952x962px.', 'themewar'),
                ]
        );
        $this->add_control(
                'img_stetch',
                [
                        'label'         => esc_html__( 'Image Strech Full', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'description'   => esc_html__('Do You Want stretch This Column?', 'themewar'),
                        'default'       => 2,
                        'options'       => [
                                1       => esc_html__( 'Yes', 'themewar' ),
                                2       => esc_html__( 'No', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'img_full_height',
                [
                        'label'         => esc_html__( 'Is Full Height', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'description'   => esc_html__('Do You Want resize this this image as full height?', 'themewar'),
                        'default'       => 2,
                        'options'       => [
                                1       => esc_html__( 'Yes', 'themewar' ),
                                2       => esc_html__( 'No', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'img_floating',
                [
                        'label'     => esc_html__( 'Image Floating', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 0,
                        'options'   => [
                                0                  => esc_html__( 'Default', 'themewar' ),
                                1                  => esc_html__( 'Left', 'themewar' ),
                                2                  => esc_html__( 'Right', 'themewar' ),
                        ],
                ]
        );
        $this->end_controls_section();
    }
    protected function render() {
        $settings       = $this->get_settings();
        $img_bg         = (isset($settings['img']['url']) && $settings['img']['url'] != '') ? $settings['img']['url'] : 'https://via.placeholder.com/952x962.jpg';
        $img_stetch     = (isset($settings['img_stetch']) && $settings['img_stetch'] > 0) ? $settings['img_stetch'] : 2;
        $img_full_height= (isset($settings['img_full_height']) && $settings['img_full_height'] > 0) ? $settings['img_full_height'] : 2;
        $img_floating = (isset($settings['img_floating']) && $settings['img_floating'] > 0) ? $settings['img_floating'] : 0;
        
        
        $class = 'normal_img clearfix ';
        $class = ($img_stetch == 1 ? 'tw-stretch-element-inside-column straceImg imgDiv2' : '');
        $class .= ($img_full_height == 1 ? ' fullheightimg ' : '');
        $img_class = '';
        if($img_class == 1){
            $img_class = 'float-left';
        }else{
            $img_class = 'float-right';
        }
        ?>
            <div class="<?php echo esc_attr($class); ?>">    
                <?php if($img_bg != ''): ?>
                    <img class="<?php echo esc_attr($img_class); ?>" src="<?php echo esc_url($img_bg); ?>" alt=""/>
                <?php endif; ?>
            </div>
        <?php
        
        
    }
    
    protected function _content_template() {
        
    }
}