<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Clients_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-clients';
    }
    
    public function get_title() {
        return esc_html__( 'Client Slider', 'themewar' );
    }

    public function get_icon() {
        return ' eicon-logo';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_tab_1',
            [
                'label'     => esc_html__('Client Logo', 'themewar')
            ]
        );
        $repeater = new \Elementor\Repeater();
            $repeater->add_control(
                'client_logo',
                [
                        'label'         => esc_html__( 'Client Logo', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('Logo size should be 98x95px.', 'themewar'),
                ]
            );
            $repeater->add_control(
                    'clinet_url', [
                        'label'             => esc_html__( 'Client URL', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'input_type'        => 'url',
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'show_external'     => true,
                        'default'           => [
                                'url'            => '',
                                'is_external'    => true,
                                'nofollow'       => true,
                        ],
                    ]
            );
            $this->add_control(
                'list',
                [
                        'label' => esc_html__( 'Client Logo', 'themewar' ),
                        'type' => Controls_Manager::REPEATER,
                        'fields' => $repeater->get_controls(),
                        'default' => [
                                [
                                        'client_logo'        => esc_html__( ' ', 'themewar' ),
                                        'url'                => esc_html__( '', 'themewar' ),
                                        'is_external'        => esc_html__( '', 'themewar' ),
                                        'nofollow'           => esc_html__( '', 'themewar' ),
                                        
                                ],
                        ],
                        'title_field' => '{{{ "Single Client" }}}',
                ]
            );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings       = $this->get_settings_for_display();
        $client         = (isset($settings['list']) && !empty($settings['list'])) ? $settings['list'] : array();
        
        if(!empty($client)):
            echo '<div class="clientSlider owl-carousel">';
                foreach($client as $item):
                    $logo       = (isset($item['client_logo']['url'])) ? $item['client_logo']['url'] : '';
                    $url        = (isset($item['clinet_url']['url'])) ? $item['clinet_url']['url'] : '';
                    $target     = (isset($item['clinet_url']['is_external'])) ? ' target="_blank"' : '' ;
                    $nofollow   = (isset($item['clinet_url']['nofollow'])) ? ' rel="nofollow"' : '' ;
                    if($logo != ''):
                    ?>
                        <div class="csItem">
                            <a href="<?php echo esc_url($url); ?>" <?php echo $target; ?> <?php echo $nofollow; ?>>
                                <img src="<?php echo esc_url($logo); ?>" alt="">
                            </a>
                        </div>
                    <?php
                    endif;
                endforeach;
            echo '</div>';
        endif;
    }
        
    protected function _content_template() {

    }
}