<?php
$sers = array(
    'post_type'         => 'tw-service',
    'post_status'       => 'publish',
    'posts_per_page'    => $service_item,
    'orderby'           => $order_by,
    'order'             => $order
);

$service = new WP_Query($sers);

if($arrow_align == 2):
    $class = 'left_right';
elseif($arrow_align == 3):
    $class = 'center_bottom';
else:
    $class = 'default';
endif;

if($service_mode == 2):
    if($service->have_posts()):
        echo '<div class="serviceSlider owl-carousel '.esc_attr($class).'">';
            while ($service->have_posts()):
                $service->the_post();
                ?>
                <div class="singleService">
                    <?php if(has_post_thumbnail()): ?>
                        <div class="serviceThumb">
                            <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-service-2'); ?>
                            <?php if($service_detail != ''): ?>
                                <a href="<?php echo get_the_permalink(); ?>"><span><?php echo esc_html($service_detail); ?></span></a>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <div class="serviceThumb">
                            <img src="http://via.placeholder.com/333x220" alt="<?php echo get_the_title(); ?>">
                            <?php if($service_detail != ''): ?>
                                <a href="<?php echo get_the_permalink(); ?>"><span><?php echo esc_html($service_detail); ?></span></a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <div class="serviceDetails">
                        <h2><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h2>
                        <p>
                            <?php
                                $content = wp_kses(get_the_content(), array());
                                if(strlen($content) > 95):
                                    echo substr($content, 0, 95); 
                                else:
                                    echo $content;
                                endif;
                            ?>
                        </p>
                    </div>
                </div>
                <?php
            endwhile;
        echo '</div>';
    endif;
    wp_reset_postdata();
else:
    if($service->have_posts()):
        echo '<div class="row">';
            while ($service->have_posts()):
                $service->the_post();
                ?>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="singleService">
                        <?php if(has_post_thumbnail()): ?>
                            <div class="serviceThumb">
                                <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-service-2'); ?>
                                <?php if($service_detail != ''): ?>
                                    <a href="<?php echo get_the_permalink(); ?>"><span><?php echo esc_html($service_detail); ?></span></a>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <div class="serviceThumb">
                                <img src="http://via.placeholder.com/333x220" alt="<?php echo get_the_title(); ?>">
                                <?php if($service_detail != ''): ?>
                                    <a href="<?php echo get_the_permalink(); ?>"><span><?php echo esc_html($service_detail); ?></span></a>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <div class="serviceDetails">
                            <h2><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h2>
                            <p>
                                <?php
                                    $content = wp_kses(get_the_content(), array());
                                    if(strlen($content) > 95):
                                        echo substr($content, 0, 95); 
                                    else:
                                        echo $content;
                                    endif;
                                ?>
                            </p>
                        </div>
                    </div>
                </div>
                <?php
            endwhile;
        echo '</div>';
    endif;
    wp_reset_postdata();
endif;
