<?php
    $shop_banner_bg = get_theme_mod('shop_banner_bg', '');
    $shop_is_breadcrumb = get_theme_mod('shop_is_breadcrumb', 1);
    $shop_bread_title = get_theme_mod('shop_bread_title', esc_html__('Shop', 'industing'));
    $shop_banner_title = get_theme_mod('shop_banner_title', esc_html__('Our Store', 'industing'));
    
    $bgStyle = '';
    if($shop_banner_bg != ''){
        $bgStyle = 'background-image: url('.$shop_banner_bg.'); background-repeat: no-repeat; background-position: center center; background-size: cover;';
    }
    
    if(defined('FW')){
        $page_is_breadcrumb = fw_get_db_post_option(get_the_ID(), 'page_is_breadcrumb', 1);
        $page_bread_title = fw_get_db_post_option(get_the_ID(), 'page_bread_title', '');
        $page_page_title = fw_get_db_post_option(get_the_ID(), 'page_page_title', '');
        
        $page_banner_bg = fw_get_db_post_option(get_the_ID(), 'page_banner_bg', '');
        $page_banner_bg = (isset($page_banner_bg['url']) && $page_banner_bg['url'] != '') ? $page_banner_bg['url'] : '';

        $shop_banner_title = ($page_page_title != '') ? $page_page_title : $shop_banner_title;
        $shop_bread_title = ($page_bread_title != '') ? $page_bread_title : $shop_bread_title;
        $shop_is_breadcrumb = ($page_is_breadcrumb != '') ? $page_is_breadcrumb : $shop_is_breadcrumb;
        if($page_banner_bg != ''){
            $bgStyle = 'background-image: url('.$page_banner_bg.'); background-repeat: no-repeat; background-attachment: scroll; background-position: center center; background-size: cover; ';
        }
    }
?>
<section class="page_banner" style="<?php echo esc_attr($bgStyle) ?>">
    <div class="container">
        <div class="row">
            <div class="col-xl-12 text-center">
                <h2><?php echo esc_html($shop_banner_title); ?></h2>
                <?php if ($shop_is_breadcrumb == 1): ?>
                    <div class="breadcrumbs">
                        <a href="<?php echo esc_url(home_url('/')) ?>"><?php echo esc_html__('Home', 'industing') ?></a><i>|</i><span><?php echo esc_html($shop_bread_title); ?></span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>