<?php
get_header();
get_template_part('template-parts/header/folio', 'header');

$folio_filter_style = get_theme_mod('folio_filter_style', 1);
$folio_width = get_theme_mod('folio_width', 1);
$folio_mode = get_theme_mod('folio_mode', 1);
$folio_style = get_theme_mod('folio_style', 1);
$folio_column = get_theme_mod('folio_column', 1);
$folio_gaping = get_theme_mod('folio_gaping', 1);
$num_of_item = get_theme_mod('num_of_item', 9);
$folio_pagi_align = get_theme_mod('folio_pagi_align', 'center');

$folio_string_limit = get_theme_mod('folio_string_limit', 63);
$folio_btn_label = get_theme_mod('folio_btn_label', esc_html__('Know More', 'industing'));

$container = 'container';
$column = 'col-xl-4 col-md-6 col-lg-4';
if($folio_width == 2){
    $container = 'header-container';
}elseif($folio_width == 3){
    $container = 'container-fluid';
}
if($folio_column == 2){
    $column = 'col-xl-3 col-md-4 col-sm-6 col-lg-3';
}
if($folio_filter_style != 3){
    $column .= ' shaf_itme ';
}
if($folio_gaping == 2){
    $column .= ' folioNoGapping ';
}

?>

<section class="commonSection projectPage">
    <div class="container">
        <?php if($folio_filter_style != 3): ?>
            <?php
            $filter_cat = array(
                'orderby'       => 'ID',
                'order'         => 'DESC', 
                'hide_empty'    => 1,
                'hierarchical'  => 1,
                'taxonomy'      => 'folio_cat'
            );
            $categories = get_categories( $filter_cat );
            if(is_array($categories) && !empty($categories)):
            ?>
            <div class="row">
                <div class="col-xl-12">
                    <div class="filterMenu <?php if($folio_filter_style == 2): ?>emptyStyle<?php endif; ?>">
                        <ul class="text-<?php if($folio_filter_style != 2): ?>right<?php else: ?>center<?php endif; ?> clearfix shafful_filter">
                            <li class="<?php if($folio_filter_style != 2): ?>all<?php else: ?> active <?php endif; ?>" data-group="all"><i class="twi-bars1"></i><?php echo esc_html__('All Cases', 'industing'); ?></li>
                            <?php foreach($categories as $cat): ?>
                                <?php
                                    $folio_cate_icon = fw_get_db_term_option($cat->term_id, 'folio_cat', 'folio_cate_icon');
                                    $ico_html = '';
                                    if(isset($folio_cate_icon['type']) && $folio_cate_icon['type'] == 'icon-font'){
                                        $ico_html = '<i class="'.$folio_cate_icon['icon-class'].'"></i>';
                                    }elseif(isset($folio_cate_icon['type']) && $folio_cate_icon['type'] == 'custom-upload'){
                                        $ico_html = '<img src="'.$folio_cate_icon['url'].'" alt="'.$cat->name.'" class="icon_img" />';
                                    }else{
                                        $ico_html = '';
                                    }
                                ?>
                                <li data-group="<?php echo esc_attr($cat->slug); ?>"><?php echo wp_kses($ico_html, industing_allowed_html()); ?><?php echo wp_kses($cat->name, industing_allowed_html()); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
    <div class="<?php echo esc_attr($container); ?>">
        <div class="row" <?php if($folio_filter_style != 3): ?>id="shafulls"<?php endif; ?>>
            <?php
                global $wp_query;
                $page = (get_query_var('paged') != '') ? get_query_var('paged') : 1;
                $fargs = array(
                        'post_type'         => 'folio',
                        'post_status'       => 'publish',
                        'posts_per_page'    => $num_of_item,
                        'orderby'           => 'date',
                        'order'             => 'desc',
                        'paged'             => $page
                );

                $wp_query = new WP_Query($fargs);
                if($wp_query->have_posts()):
                    $i = 1;
                    while($wp_query->have_posts()):
                        $wp_query->the_post();
                        
                        $category = '';
                        $data_groups = '[';
                        $terms = get_the_terms(get_the_ID(), 'folio_cat');
                        if (is_array($terms) && !empty($terms)):
                            $p = 1;
                            $c = count($terms);
                            foreach ($terms as $term):
                                if($p == $c):
                                    $category .= '<a  class="cate" href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                                    $data_groups .= '"'.$term->slug.'"';
                                else:
                                    $category .= '<a  class="cate" href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                                    if($folio_style == 3 || $folio_style == 4){
                                        $category .= '<span>/</span>';
                                    }else{
                                        $category .= ', ';
                                    }
                                    $data_groups .= '"'.$term->slug.'",';
                                endif;
                                $p++;
                            endforeach;
                        endif;
                        $data_groups .= ']';
                        ?>
                        <?php if($folio_style == 2): ?>
                            <?php $image_size = ($i % 2 == 0 && $folio_mode == 2 ? 'full' : 'industing-folio-s2-1'); ?>
                            <div class="<?php echo esc_attr($column); ?>" <?php if($folio_filter_style != 3): ?>data-groups='<?php echo esc_attr($data_groups) ?>' <?php endif; ?>>
                                <div class="singleFolio_03 text-left">
                                    <?php if(has_post_thumbnail()): ?>
                                        <?php echo get_the_post_thumbnail(get_the_ID(), $image_size); ?>
                                    <?php else: ?>
                                        <img src="http://via.placeholder.com/463x563" alt="<?php echo get_the_title(); ?>">
                                    <?php endif; ?>
                                    <div class="folioHover_03">
                                        <h2><?php echo get_the_title(); ?></h2>
                                        <?php if($category != ''): ?>
                                        <div class="cats"><?php echo wp_kses($category, industing_allowed_html()); ?></div>
                                        <?php endif; ?>
                                        <a class="mores" href="<?php echo get_the_permalink(); ?>"></a>
                                    </div>
                                </div>
                            </div>
                        <?php elseif($folio_style == 3): ?>
                            <?php $image_size = ($i % 2 == 0 && $folio_mode == 2 ? 'industing-blog-3' : 'industing-folio-s2-2'); ?>
                            <div class="<?php echo esc_attr($column); ?>" <?php if($folio_filter_style != 3): ?>data-groups='<?php echo esc_attr($data_groups) ?>' <?php endif; ?>>
                                <div class="singleFolio_04 text-center">
                                    <div class="sf4_img">
                                        <?php if(has_post_thumbnail()): ?>
                                            <?php echo get_the_post_thumbnail(get_the_ID(), $image_size); ?>
                                        <?php else: ?>
                                            <img src="http://via.placeholder.com/360x250" alt="<?php echo get_the_title(); ?>">
                                        <?php endif; ?>
                                        <div class="sf4_hov">
                                            <a href="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>" class="prePhoto2"><i class="twi-search-plus2"></i></a>
                                            <a href="<?php echo get_the_permalink(); ?>" class="detailsLink2"><i class="twi-link2"></i></a>
                                        </div>
                                    </div>
                                    <div class="sf4_det">
                                        <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
                                        <?php if($category != ''): ?>
                                        <p class="sf4_cat"><?php echo wp_kses($category, industing_allowed_html()); ?></p>
                                        <?php endif; ?>
                                        <div class="sf4_con">
                                            <?php echo substr(wp_strip_all_tags(get_the_content()), 0, $folio_string_limit); ?>
                                        </div>
                                        <div class="clearfix"></div>
                                    </div>
                                </div>
                            </div>
                        <?php elseif($folio_style == 4): ?>
                            <?php $image_size = ($i % 2 == 0 && $folio_mode == 2 ? 'industing-blog-3' : 'industing-folio-s2-2'); ?>
                            <div class="<?php echo esc_attr($column); ?>" <?php if($folio_filter_style != 3): ?>data-groups='<?php echo esc_attr($data_groups) ?>' <?php endif; ?>>
                                <div class="singleFolio_05 text-center">
                                    <div class="sf5_img">
                                        <?php if(has_post_thumbnail()): ?>
                                            <?php echo get_the_post_thumbnail(get_the_ID(), $image_size); ?>
                                        <?php else: ?>
                                            <img src="http://via.placeholder.com/360x250" alt="<?php echo get_the_title(); ?>">
                                        <?php endif; ?>
                                        <div class="sf5_meta clearfix">
                                            <?php
                                                $folio_date = '';
                                                if(defined('FW')){
                                                    $folio_date = fw_get_db_post_option(get_the_ID(), 'folio_date', '');
                                                    $folio_date = ($folio_date != '' ? date('Y-m-d', strtotime($folio_date)) : get_the_time('Y-m-d'));
                                                }
                                                
                                            ?>
                                            <a href="<?php echo get_the_permalink(); ?>" class="float-left"><?php echo human_time_diff(strtotime($folio_date), current_time('U')).esc_html__(' ago', 'industing'); ?></a>
                                            <a href="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>" class="float-right prePhoto3"><i class="twi-search-plus2"></i></a>
                                        </div>
                                    </div>
                                    <div class="sf5_det">
                                        <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
                                        <?php if($category != ''): ?>
                                        <p class="sf5_cat"><?php echo wp_kses($category, industing_allowed_html()); ?></p>
                                        <?php endif; ?>
                                        <div class="sf5_con">
                                            <?php echo substr(wp_strip_all_tags(get_the_content()), 0, $folio_string_limit); ?>
                                        </div>

                                        <a href="<?php echo get_the_permalink(); ?>"><?php echo esc_html($folio_btn_label) ?></a>
                                        <div class="clearfix"></div>
                                    </div>
                                </div>
                            </div>
                        <?php else: ?>
                            <?php $image_size = ($folio_mode == 1 ? 'industing-folio-1' : 'full'); ?>
                            <div class="<?php echo esc_attr($column); ?>" <?php if($folio_filter_style != 3): ?>data-groups='<?php echo esc_attr($data_groups) ?>' <?php endif; ?>>
                                <div class="singlefolio">
                                    <?php if(has_post_thumbnail()): ?>
                                        <?php echo get_the_post_thumbnail(get_the_ID(), $image_size); ?>
                                    <?php else: ?>
                                        <img src="http://via.placeholder.com/370x290" alt="<?php echo get_the_title(); ?>">
                                    <?php endif; ?>
                                    <div class="folioHover">
                                        <?php if($category != ''): ?>
                                        <p><?php echo wp_kses($category, industing_allowed_html()); ?></p>
                                        <?php endif; ?>
                                        <h4><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h4>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php
                        $i++;
                    endwhile;
                endif;
            ?>
        </div>
        <div class="row <?php if($folio_gaping == 1){ ?>mt25<?php }else{ ?>mt55<?php } ?>">
            <div class="col-lg-12 col-sm-12 mt3">
                <div class="ind_pagination text-<?php echo esc_attr($folio_pagi_align); ?>">
                    <?php 
                        the_posts_pagination( array(
                            'prev_text' => '<i class="twi-arrow-left2"></i>',
                            'next_text' =>  '<i class="twi-arrow-right2"></i>',
                            'before_page_number' => '0'
                        ));
                    ?>
                </div>
            </div>
        </div>
        
    </div>
</section>

<?php
    $folio_bloks = get_theme_mod('folio_bloks', '');
    $blocks_id = array();
    if(!empty($folio_bloks)){
        foreach($folio_bloks as $sb):
            if($sb['block_ids'] != '' && $sb['block_ids'] != 'none'):
                $blocks_id[] = $sb['block_ids'];
            endif;
        endforeach;
        $bloks = array(
            'post_type'     => 'blocks',
            'post_status'   => 'publish',
            'post__in'      => $blocks_id
        );
        $blok = new WP_Query($bloks);
        if($blok->have_posts()):
            while($blok->have_posts()):
            $blok->the_post();
            the_content();
            endwhile;
        endif;
    }
get_footer();
