<?php
get_header();
get_template_part('template-parts/header/single-folio', 'header');
$current_post = get_the_ID();


$folio_is_social = fw_get_db_post_option(get_the_ID(), 'folio_is_social', '');
$folio_single_style = get_theme_mod('folio_single_style', 3);
$folio_single_pagination = get_theme_mod('folio_single_pagination', 1);
?>
<section class="commonSection projectDetailsPage">
    <div class="container">
        <div class="row">
            <?php
                while(have_posts()): the_post();
                    if($folio_single_style == 1):
                        get_template_part('template-parts/folios/folios', 'left');
                    elseif($folio_single_style == 2):
                        get_template_part('template-parts/folios/folios', 'full');
                    else:
                        get_template_part('template-parts/folios/folios', 'right');
                    endif;
                endwhile;
            ?>
        </div>
        <?php if($folio_single_pagination == 1): ?>
        <?php
            $prevpost = get_previous_post();
            $nextpost = get_next_post();
        ?>
        <div class="row">
            <div class="col-lg-12">
                <div class="nextprevPagination">
                    <div class="row">
                        <?php if($folio_single_style == 2): ?>
                            <div class="col-sm-4 text-left">
                                <?php if(!empty($prevpost)): ?>
                                    <a class="prevFolio" href="<?php echo get_the_permalink($prevpost->ID); ?>"><i class="twi-angle-left1"></i><?php echo esc_html__('Previous', 'industing') ?></a>
                                <?php endif; ?>
                            </div>
                            <div class="col-sm-4 text-center">
                                <?php if($folio_is_social == 1): ?>
                                    <div class="pd_social s_fw">
                                        <a href="http://www.facebook.com/share.php?u=<?php echo get_the_permalink(); ?>&title=<?php echo get_the_title(); ?>"><i class="twi-facebook-f"></i>
                                        </a><a href="http://twitter.com/intent/tweet?status=<?php echo get_the_title(); ?>+<?php echo get_the_permalink(); ?>"><i class="twi-twitter"></i>
                                        </a><a href="https://www.tumblr.com/widgets/share/tool?canonicalUrl='.get_the_permalink($pid).'&title='.get_the_title($pid).'&caption='.get_the_title($pid).'&tags={hash_tags}"><i class="twi-tumblr"></i>
                                        </a><a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo get_the_permalink(); ?>&title=<?php echo get_the_title(); ?>&source=<?php echo esc_url(home_url('/')); ?>"><i class="twi-linkedin"></i>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-sm-4 text-right">
                                <?php if(!empty($nextpost)): ?>
                                    <a class="nextFolio" href="<?php echo get_the_permalink($nextpost->ID); ?>"><?php echo esc_html__('Next', 'industing') ?><i class="twi-angle-right1"></i></a>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <div class="col-lg-6 col-sm-6 col-xs-6 text-left">
                                <?php if(!empty($prevpost)): ?>
                                    <a class="prevFolio" href="<?php echo get_the_permalink($prevpost->ID); ?>"><i class="twi-angle-left1"></i><?php echo esc_html__('Previous', 'industing') ?></a>
                                <?php endif; ?>
                            </div>
                            <div class="col-lg-6 col-sm-6 col-xs-6 text-right">
                                <?php if(!empty($nextpost)): ?>
                                    <a class="nextFolio" href="<?php echo get_the_permalink($nextpost->ID); ?>"><?php echo esc_html__('Next', 'industing') ?><i class="twi-angle-right1"></i></a>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</section>
<?php 
$folio_single_related = get_theme_mod('folio_single_related', 1);
$folio_arrow_related = get_theme_mod('folio_arrow_related', 1);
$folio_single_rt = get_theme_mod('folio_single_rt', '');
$folio_single_noi = get_theme_mod('folio_single_noi', '');

if($folio_single_related == 1): ?>
<section class="commonSection relatedworfsection">
    <?php if($folio_single_rt != '' || $folio_arrow_related != ''): ?>
    <div class="container mb60">
        <div class="row">
            <?php if($folio_single_rt != ''): ?>
            <div class="col-xl-1 col-md-4">
                <div class="rel_btns">
                    <span><i class="twi-bars1"></i><?php echo esc_html($folio_single_rt); ?></span>
                </div>
            </div>
            <?php endif; ?>
            <div class="col-xl-10 col-md-4"></div>
            <?php if($folio_arrow_related == 1): ?>
            <div class="col-xl-1 col-md-4">
                <div class="relatedArrows">
                    <span class="prevRelated"><i class="twi-arrow-left2"></i></span>
                    <span class="nextRelated"><i class="twi-arrow-right2"></i></span>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>
        <?php
            $rf = array(
                'post_type'     => 'folio',
                'post_status'   => 'publish',
                'orderby'       => 'date',
                'order'         => 'DESC',
                'posts_per_page'=> $folio_single_noi,
                'post__not_in'  => array($current_post)
            );
            
            $rfp = new WP_Query($rf);
            if($rfp->have_posts()):
                ?>
                <div class="relatedSlider">
                    <?php
                    while($rfp->have_posts()):
                        $rfp->the_post();

                        $category = '';
                        $terms = get_the_terms(get_the_ID(), 'folio_cat');
                        if (is_array($terms) && !empty($terms)):
                            $p = 1;
                            $c = count($terms);
                            foreach ($terms as $term):
                                if($p == $c):
                                    $category .= '<a class="cate" href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                                else:
                                    $category .= '<a class="cate" href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>, ';
                                endif;
                                $p++;
                            endforeach;
                        endif;
                        ?>
                        <div class="singlefolio">
                            <?php if(has_post_thumbnail()): ?>
                                <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-folio-3'); ?>
                            <?php else: ?>
                                <img src="http://via.placeholder.com/421x281" alt="<?php the_title_attribute(); ?>">
                            <?php endif; ?>
                            <div class="folioHover">
                                <p><?php echo wp_kses($category, industing_allowed_html()); ?></p>
                                <h4><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h4>
                            </div>
                        </div>
                        <?php
                    endwhile;
                    ?>
                </div>
                <?php
            endif;
            wp_reset_postdata();
        ?>
</section>
<?php
endif;
    $sing_folio_bloks = get_theme_mod('sing_folio_bloks', '');
    $blocks_id = array();
    if(!empty($sing_folio_bloks)){
        foreach($sing_folio_bloks as $sb):
            if($sb['block_ids'] != '' && $sb['block_ids'] != 'none'):
                $blocks_id[] = $sb['block_ids'];
            endif;
        endforeach;
        $bloks = array(
            'post_type'     => 'blocks',
            'post_status'   => 'publish',
            'post__in'      => $blocks_id
        );
        $blok = new WP_Query($bloks);
        if($blok->have_posts()):
            while($blok->have_posts()):
            $blok->the_post();
            the_content();
            endwhile;
        endif;
    }
get_footer();