<?php
/**
 * The header for our theme
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>
    <?php
        if(function_exists('industing_preloader_creator')):
            industing_preloader_creator();
        endif;
        $header_style = get_theme_mod('header_style', 1);
        if($header_style == 2){
            require get_parent_theme_file_path('/template-parts/navigation/navigation2.php');
        }elseif($header_style == 3){
            require get_parent_theme_file_path('/template-parts/navigation/navigation3.php');
        }else{
            require get_parent_theme_file_path('/template-parts/navigation/navigation1.php');
        }
    ?>