<?php
$bloks = array(
    'post_type'       => 'blocks',
    'post_status'     => 'publish',
    'posts_per_page'  => -1,
    'orderby'         => 'title',
    'order'           => 'ASC'
);
$all_bloks = array(
    'none' => esc_html__('None', 'industing')
);
$blok = new WP_Query($bloks);
if($blok->have_posts()):
    while($blok->have_posts()):
    $blok->the_post();
    $all_bloks[get_the_ID()] = get_the_title();
    endwhile;
endif;
wp_reset_postdata();

$fields[] = array(
        'type'        => 'image',
	'settings'    => 'mem_single_banner_bg',
	'label'       => esc_html__( 'Upload Banner BG', 'industing' ),
	'section'     => 'member_single_settings',
	'default'     => '',
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'mem_banner_overlay',
	'label'       => esc_html__( 'Banner Overlay Color', 'industing' ),
	'section'     => 'member_single_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner:after',
                        'property' => 'background'
		],
	],
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'mem_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb', 'industing' ),
	'section'     => 'member_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'mem_banner_title',
        'label'       => esc_html__( 'Banner Title', 'industing' ),
        'section'     => 'member_single_settings',
        'transport'   => 'postMessage',
        'js_vars'     => array(
            array(
                'element'  => '.page_banner h2',
                'function' => 'html'
            ),
        ),
        'default'     => esc_html__( 'Member Details', 'industing' ),
);
$fields[] = array(
        'type'          => 'text',
	'settings'      => 'mem_bread_title',
	'label'         => esc_html__( 'Breadcrumb Title', 'industing' ),
	'section'       => 'member_single_settings',
	'default'       => esc_html__('Team', 'industing'),
        'transport'     => 'postMessage',
        'js_vars'       => array(
            array(
                'element'  => '.breadcrumbs span',
                'function' => 'html'
            ),
        ),
);
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'mem_single_custom',
	'label'       => FALSE,
	'section'     => 'member_single_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[] = array(
	'type'        => 'switch',
	'settings'    => 'is_colleague',
	'label'       => esc_html__( 'Is Colleague?', 'industing' ),
	'section'     => 'member_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[] = array(
        'type'          => 'text',
	'settings'      => 'mem_col_subtitle',
	'label'         => esc_html__( 'Area Sub Title', 'industing' ),
	'section'       => 'member_single_settings',
	'default'       => '',
        'required'      => array( 
            array( 
                'setting'   => 'is_colleague',
                'operator'  => '==',
                'value'     => '1' 
            )
        ),
);
$fields[] = array(
        'type'          => 'text',
	'settings'      => 'mem_col_title',
	'label'         => esc_html__( 'Area Title', 'industing' ),
	'section'       => 'member_single_settings',
	'default'       => '',
        'required'      => array( 
            array( 
                'setting'   => 'is_colleague',
                'operator'  => '==',
                'value'     => '1' 
            )
        ),
);
$fields[] = array(
        'type'        => 'slider',
	'settings'    => 'mem_col_num',
	'label'       => esc_html__( 'Number of Colleague', 'industing' ),
	'section'     => 'member_single_settings',
	'default'     => 5,
	'choices'     => [
		'min'  => 3,
		'max'  => 100,
		'step' => 1,
	],
        'required'      => array( 
            array( 
                'setting'   => 'is_colleague',
                'operator'  => '==',
                'value'     => '1' 
            )
        ),
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'mem_single_custom3',
	'label'       => FALSE,
	'section'     => 'member_single_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[] = array(
    'type'              => 'repeater',
	'label'         => esc_html__( 'Add Blocks', 'industing' ),
	'section'       => 'member_single_settings',
	'settings'      => 'sing_member_bloks',
	'row_label' => [
		'type'  => 'text',
		'value' => esc_html__('Block', 'industing' ),
	],
	'button_label' => esc_html__('Add New Block', 'industing' ),
	'default'      => [],
	'fields' => [
		'block_ids' => [
			'type'        => 'select',
                        'label'       => esc_html__( 'Block', 'industing' ),
                        'default'     => 'none',
                        'choices'     => $all_bloks
		]
	]
);