<?php
$bloks = array(
    'post_type'     => 'blocks',
    'post_status'   => 'publish',
    'posts_per_page'  => -1,
    'orderby'        => 'title',
    'order'          => 'ASC'
);
$all_bloks = array(
    'none' => esc_html__('None', 'industing')
);
$blok = new WP_Query($bloks);
if($blok->have_posts()):
    while($blok->have_posts()):
    $blok->the_post();
    $all_bloks[get_the_ID()] = get_the_title();
    endwhile;
endif;
wp_reset_postdata();

$fields[] = array(
        'type'        => 'image',
	'settings'    => 'mem_list_banner_bg',
	'label'       => esc_html__( 'Upload Banner BG', 'industing' ),
	'section'     => 'member_listing_settings',
	'default'     => '',
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'mem_list_banner_overlay',
	'label'       => esc_html__( 'Banner Overlay Color', 'industing' ),
	'section'     => 'member_listing_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner:after',
                        'property' => 'background'
		],
	],
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'mem_list_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb', 'industing' ),
	'section'     => 'member_listing_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'mem_list_banner_title',
        'label'       => esc_html__( 'Banner Title', 'industing' ),
        'section'     => 'member_listing_settings',
        'transport'   => 'postMessage',
        'js_vars'     => array(
            array(
                'element'  => '.page_banner h2',
                'function' => 'html'
            ),
        ),
        'default'     => esc_html__( 'Our Team', 'industing' ),
);
$fields[] = array(
        'type'          => 'text',
	'settings'      => 'mem_list_bread_title',
	'label'         => esc_html__( 'Breadcrumb Title', 'industing' ),
	'section'       => 'member_listing_settings',
	'default'       => esc_html__('Team', 'industing'),
        'transport'     => 'postMessage',
        'js_vars'       => array(
            array(
                'element'  => '.breadcrumbs span',
                'function' => 'html'
            ),
        ),
);
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'mem_list_single_custom',
	'label'       => FALSE,
	'section'     => 'member_listing_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);

$fields[] = array(
        'type'        => 'select',
        'settings'    => 'mem_list_style',
        'label'       => esc_html__( 'Member Style', 'industing' ),
        'section'     => 'member_listing_settings',
        'default'     => '1',
        'choices'     => array(
                '1'     => esc_html__( 'Style 1', 'industing' ),
                '2'     => esc_html__( 'Style 2', 'industing' ),
        ),
);
$fields[] = array(
        'type'        => 'slider',
	'settings'    => 'mem_list_num_of_item',
	'label'       => esc_html__( 'Number Of Items', 'industing' ),
	'section'     => 'member_listing_settings',
	'default'     => 6,
	'choices'     => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	],
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'mem_pagi_align',
        'label'       => esc_html__( 'Pagination Alignment', 'industing' ),
        'section'     => 'member_listing_settings',
        'default'     => 'center',
        'choices'     => array(
                'left'      => esc_html__('Left','industing'),
                'center'      => esc_html__('Center','industing'),
                'right'      => esc_html__('Right','industing'),
        ),
);
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'mem_list_single_custom_2',
	'label'       => FALSE,
	'section'     => 'member_listing_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);

$fields[] = array(
    'type'              => 'repeater',
	'label'         => esc_html__( 'Add Blocks', 'industing' ),
	'section'       => 'member_listing_settings',
	'settings'      => 'mem_list_bloks',
	'row_label' => [
		'type'  => 'text',
		'value' => esc_html__('Block', 'industing' ),
	],
	'button_label' => esc_html__('Add New Block', 'industing' ),
	'default'      => [],
	'fields' => [
		'block_ids' => [
			'type'        => 'select',
                        'label'       => esc_html__( 'Block', 'industing' ),
                        'default'     => 'none',
                        'choices'     => $all_bloks
		]
	]
);