<?php
$fields[] = array(
	'type'        => 'dimensions',
	'settings'    => 'fo_padding',
	'label'       => esc_html__( 'Footer Padding', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => [
		'padding-top'    => '',
		'padding-bottom'    => '',
	],
        'transport'     => 'auto',
        'output'      => [
		[
			'element' => '.footer_01',
		],
		[
			'element' => '.footer_02',
		],
	],
);
$fields[]= array(
        'type'        => 'background',
	'settings'    => 'fo_bg_setting',
	'label'       => esc_html__( 'Footer Background', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => [
		'background-color'      => '',
		'background-image'      => '',
		'background-repeat'     => '',
		'background-position'   => '',
		'background-size'       => '',
		'background-attachment' => '',
	],
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.footer_01',
		],
		[
			'element' => '.footer_02',
		],
	],
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'fo_custom1',
	'label'       => FALSE,
	'section'     => 'footer_styling',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);

$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_color',
	'label'       => esc_html__( 'Widget Title Color', 'industing' ),
	'description' => esc_html__( 'Insert your custom color for Widget Title.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.footer_01 .widget_title',
			'property' => 'color'
		],
		[
			'element' => '.footer_02 .widget_title',
			'property' => 'color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_high_color',
	'label'       => esc_html__( 'Widget Title Highlighted', 'industing' ),
	'description' => esc_html__( 'Insert your custom color for Widget Title highlighted dot color.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.footer_01 .widget_title:after',
			'property' => 'color'
		],
		[
			'element' => '.footer_02 .widget_title:after',
			'property' => 'color'
		],
	],
);

$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_text_color',
	'label'       => esc_html__( 'Widget Text Color', 'industing' ),
	'description' => esc_html__( 'Insert color for all widget plain text color.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.about_widget p',
			'property' => 'color'
		],
		[
			'element' => '.footer_01 .widget .allfeeds span',
			'property' => 'color'
		],
		[
			'element' => 'footer .widget .textwidget',
			'property' => 'color'
		],
		[
			'element' => 'footer .serviceItem span',
			'property' => 'color'
		],
		[
			'element' => 'footer .newsfeed p a',
			'property' => 'color'
		],
		[
			'element' => 'footer .newsfeed p i',
			'property' => 'color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_link_color',
	'label'       => esc_html__( 'Widget Link Color', 'industing' ),
	'description' => esc_html__( 'Insert color for all widget link text color.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.footer_01 .widget ul li a',
			'property' => 'color'
		],
		[
			'element' => '.footer_02 .widget ul li a',
			'property' => 'color'
		],
		[
			'element' => '.footer_01 .widget .allfeeds h6 a',
			'property' => 'color'
		],
		[
			'element' => '.footer_01 .widget ul li a:before',
			'property' => 'color'
		],
		[
			'element' => 'footer .widget .textwidget a',
			'property' => 'color'
		],
		[
			'element' => 'footer .serviceItem h5 a',
			'property' => 'color'
		],
		[
			'element' => 'footer .newsfeed h4 a',
			'property' => 'color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_link_hover_color',
	'label'       => esc_html__( 'Widget Link Hover Color', 'industing' ),
	'description' => esc_html__( 'Insert color for all widget link text hover color.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.footer_01 .widget ul li a:hover',
			'property' => 'color'
		],
		[
			'element' => '.footer_02 .widget ul li a:hover',
			'property' => 'color'
		],
		[
			'element' => '.footer_01 .widget .allfeeds h6 a:hover',
			'property' => 'color'
		],
		[
			'element' => 'footer .widget .textwidget a:hover',
			'property' => 'color'
		],
		[
			'element' => 'footer .serviceItem h5 a:hover',
			'property' => 'color'
		],
		[
			'element' => 'footer .newsfeed h4 a:hover',
			'property' => 'color'
		],
		[
			'element' => 'footer .newsfeed p a:hover',
			'property' => 'color'
		],
		[
			'element' => '.footer_02 .widget ul li a:hover:before',
			'property' => 'background-color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_border_color',
	'label'       => esc_html__( 'Widget Border Color', 'industing' ),
	'description' => esc_html__( 'Insert color for all widget borders.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'footer .newsFeeds div.newsfeed',
			'property' => 'border-bottom-color'
		],
		[
			'element' => '.footer_02 .widget ul',
			'property' => 'border-left-color'
		],
		[
			'element' => '.footer_02 .widget ul li a:before',
			'property' => 'background-color'
		],
	],
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'fo_custom2',
	'label'       => FALSE,
	'section'     => 'footer_styling',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_social_color',
	'label'       => esc_html__( 'Widget Social Color', 'industing' ),
	'description' => esc_html__( 'Insert color for all widgets social icon color.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'footer .f1_s4 .industing_social_widget .socialLinks a',
			'property' => 'color'
		],
		[
			'element' => 'footer .fo_social a',
			'property' => 'color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_social_hover_color',
	'label'       => esc_html__( 'Widget Social Hover Color', 'industing' ),
	'description' => esc_html__( 'Insert color for all widgets social icon hover color.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'footer .f1_s4 .industing_social_widget .socialLinks a:hover',
			'property' => 'color'
		],
		[
			'element' => 'footer .fo_social a:hover',
			'property' => 'color'
		],
	],
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'fo_custom2',
	'label'       => FALSE,
	'section'     => 'footer_styling',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_input_bg',
	'label'       => esc_html__( 'Subscription Field BG', 'industing' ),
	'description' => esc_html__( 'Insert BG color for subscription form input field.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'footer .mc4wp-form input[type="email"]',
			'property' => 'background-color'
		],
		[
			'element' => 'footer .mc4wp-form input[type="text"]',
			'property' => 'background-color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_input_color',
	'label'       => esc_html__( 'Subscription Field Color', 'industing' ),
	'description' => esc_html__( 'Insert color for subscription form input field.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'footer .mc4wp-form input[type="email"]',
			'property' => 'color'
		],
		[
			'element' => 'footer .mc4wp-form input[type="text"]',
			'property' => 'color'
		],
		[
			'element' => 'footer .mc4wp-form input[type="email"]::-moz-placeholder',
			'property' => 'color',
                        'suffix' => ' !important'
		],
		[
			'element' => 'footer .mc4wp-form input[type="text"]::-moz-placeholder',
			'property' => 'color',
                        'suffix' => ' !important'
		],
		[
			'element' => 'footer .mc4wp-form input[type="email"]::-ms-input-placeholder',
			'property' => 'color',
                        'suffix' => ' !important'
		],
		[
			'element' => 'footer .mc4wp-form input[type="text"]::-ms-input-placeholder',
			'property' => 'color',
                        'suffix' => ' !important'
		],
		[
			'element' => 'footer .mc4wp-form input[type="email"]::-webkit-input-placeholder',
			'property' => 'color',
                        'suffix' => ' !important'
		],
		[
			'element' => 'footer .mc4wp-form .mc4wp-form input[type="text"]::-webkit-input-placeholder',
			'property' => 'color',
                        'suffix' => ' !important'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_button_bg',
	'label'       => esc_html__( 'Subscription Button BG', 'industing' ),
	'description' => esc_html__( 'Insert BG color for subscription form button.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'footer .mc4wp-form button',
			'property' => 'background-color'
		],
		[
			'element' => 'footer .mc4wp-form input[type="submit"]',
			'property' => 'background-color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_button_hover_bg',
	'label'       => esc_html__( 'Subscription Button Hover BG', 'industing' ),
	'description' => esc_html__( 'Insert BG color for subscription form button hover.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'footer .mc4wp-form button:hover',
			'property' => 'background-color'
		],
		[
			'element' => 'footer .mc4wp-form input[type="submit"]:hover',
			'property' => 'background-color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_button_t_color',
	'label'       => esc_html__( 'Subscription Button Color', 'industing' ),
	'description' => esc_html__( 'Insert color for subscription form button.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'footer .mc4wp-form button',
			'property' => 'color'
		],
		[
			'element' => 'footer .mc4wp-form input[type="submit"]',
			'property' => 'color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_button_t_hover',
	'label'       => esc_html__( 'Subscription Button Hover Color', 'industing' ),
	'description' => esc_html__( 'Insert color for subscription form button hover.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'footer .mc4wp-form button:hover',
			'property' => 'color'
		],
		[
			'element' => 'footer .mc4wp-form input[type="submit"]:hover',
			'property' => 'color'
		],
	],
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'fo_custom3',
	'label'       => FALSE,
	'section'     => 'footer_styling',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_phone_bg',
	'label'       => esc_html__( 'Phone BG', 'industing' ),
	'description' => esc_html__( 'Insert BG color for About widget phone number area.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'footer .caller',
			'property' => 'background-color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_phone_icon',
	'label'       => esc_html__( 'Phone Icon Color', 'industing' ),
	'description' => esc_html__( 'Insert color for About widget phone number icon.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'footer .caller i',
			'property' => 'color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_phone_label',
	'label'       => esc_html__( 'Phone Label Color', 'industing' ),
	'description' => esc_html__( 'Insert color for About widget phone number label.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'footer .caller span',
			'property' => 'color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'fo_wt_phone_number',
	'label'       => esc_html__( 'Phone Number Color', 'industing' ),
	'description' => esc_html__( 'Insert color for About widget phone number.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'footer .caller h3',
			'property' => 'color'
		],
	],
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'fo_custom4',
	'label'       => FALSE,
	'section'     => 'footer_styling',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[] = array(
	'type'        => 'dimensions',
	'settings'    => 'fo_1_widget_margin',
	'label'       => esc_html__( 'Footer 1st Col Widget Margin', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => [
		'margin-top'    => '',
		'margin-bottom'    => '',
	],
        'transport'     => 'auto',
        'output'      => [
		[
			'element' => '.footer_01 .f1_col1 .widget',
		],
		[
			'element' => '.footer_02 .f2_col1 .widget',
		],
	],
);
$fields[] = array(
	'type'        => 'dimensions',
	'settings'    => 'fo_1_widget_padding',
	'label'       => esc_html__( 'Footer 1st Col Widget Padding', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => [
		'padding-left'    => '',
		'padding-right'    => '',
	],
        'transport'     => 'auto',
        'output'      => [
		[
			'element' => '.footer_01 .f1_col1',
		],
		[
			'element' => '.footer_02 .f2_col1',
		],
	],
);
$fields[] = array(
	'type'        => 'dimensions',
	'settings'    => 'fo_2_widget_margin',
	'label'       => esc_html__( 'Footer 2nd Col Widget Margin', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => [
		'margin-top'    => '',
		'margin-bottom'    => '',
	],
        'transport'     => 'auto',
        'output'      => [
		[
			'element' => '.footer_01 .f1_col2 .widget',
		],
		[
			'element' => '.footer_02 .f2_col2 .widget',
		],
	],
);
$fields[] = array(
	'type'        => 'dimensions',
	'settings'    => 'fo_2_widget_padding',
	'label'       => esc_html__( 'Footer 2nd Col Widget Padding', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => [
		'padding-left'    => '',
		'padding-right'    => '',
	],
        'transport'     => 'auto',
        'output'      => [
		[
			'element' => '.footer_01 .f1_col2',
		],
		[
			'element' => '.footer_02 .f2_col2',
		],
	],
);
$fields[] = array(
	'type'        => 'dimensions',
	'settings'    => 'fo_3_widget_margin',
	'label'       => esc_html__( 'Footer 3rd Col Widget Margin', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => [
		'margin-top'    => '',
		'margin-bottom'    => '',
	],
        'transport'     => 'auto',
        'output'      => [
		[
			'element' => '.footer_01 .f1_col3 .widget',
		],
		[
			'element' => '.footer_02 .f2_col3 .widget',
		],
	],
);
$fields[] = array(
	'type'        => 'dimensions',
	'settings'    => 'fo_3_widget_padding',
	'label'       => esc_html__( 'Footer 3rd Col Widget Padding', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => [
		'padding-left'    => '',
		'padding-right'    => '',
	],
        'transport'     => 'auto',
        'output'      => [
		[
			'element' => '.footer_01 .f1_col3',
		],
		[
			'element' => '.footer_02 .f2_col3',
		],
	],
);
$fields[] = array(
	'type'        => 'dimensions',
	'settings'    => 'fo_4_widget_margin',
	'label'       => esc_html__( 'Footer 4th Col Widget Margin', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => [
		'margin-top'    => '',
		'margin-bottom'    => '',
	],
        'transport'     => 'auto',
        'output'      => [
		[
			'element' => '.footer_01 .f1_col4 .widget',
		],
		[
			'element' => '.footer_02 .f2_col4 .widget',
		],
	],
);
$fields[] = array(
	'type'        => 'dimensions',
	'settings'    => 'fo_4_widget_padding',
	'label'       => esc_html__( 'Footer 4th Col Widget Padding', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => [
		'padding-left'    => '',
		'padding-right'    => '',
	],
        'transport'     => 'auto',
        'output'      => [
		[
			'element' => '.footer_01 .f1_col4',
		],
		[
			'element' => '.footer_02 .f2_col4',
		],
	],
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'fo_custom5',
	'label'       => FALSE,
	'section'     => 'footer_styling',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[]= array(
        'type'        => 'background',
	'settings'    => 'copy_bg_setting',
	'label'       => esc_html__( 'Copyright Area BG', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => [
		'background-color'      => '',
		'background-image'      => '',
		'background-repeat'     => '',
		'background-position'   => '',
		'background-size'       => '',
		'background-attachment' => '',
	],
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.copyright_section',
		]
	],
);
$fields[] = array(
	'type'        => 'dimensions',
	'settings'    => 'copy_padding',
	'label'       => esc_html__( 'Copyright Padding', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => [
		'padding-top'    => '',
		'padding-bottom' => '',
	],
        'transport'     => 'auto',
        'output'      => [
		[
			'element' => '.siteinfo',
		],
	],
);

$fields[]= array(
        'type'        => 'color',
	'settings'    => 'copy_border_color',
	'label'       => esc_html__( 'Copyright Border Color', 'industing' ),
	'description' => esc_html__( 'Insert your custom color for copyright area border.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.siteinfo',
			'property' => 'border-top-color'
		]
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'copy_text_color',
	'label'       => esc_html__( 'Copyright Text Color', 'industing' ),
	'description' => esc_html__( 'Insert your custom color for copyright area text.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.siteinfo',
			'property' => 'color'
		],
	],
);

$fields[]= array(
        'type'        => 'color',
	'settings'    => 'copy_link_color',
	'label'       => esc_html__( 'Copyright Link Color', 'industing' ),
	'description' => esc_html__( 'Insert your custom color for all link text in copyright area.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.siteinfo a',
			'property' => 'color'
		],
	],
);

$fields[]= array(
        'type'        => 'color',
	'settings'    => 'copy_link_hov_color',
	'label'       => esc_html__( 'Copyright Link Hover Color', 'industing' ),
	'description' => esc_html__( 'Insert your custom color for all link text hover in copyright area.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.siteinfo a:hover',
			'property' => 'color'
		]
	],
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'fo_custom6',
	'label'       => FALSE,
	'section'     => 'footer_styling',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'back_to_top_bg',
	'label'       => esc_html__( 'BackToTop Btn BG', 'industing' ),
	'description' => esc_html__( 'Insert your custom BG color for back to top button.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '#backtotop',
			'property' => 'background-color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'back_to_top_hover_bg',
	'label'       => esc_html__( 'BackToTop Btn Hover BG', 'industing' ),
	'description' => esc_html__( 'Insert your custom BG color for back to top button hover.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '#backtotop:after',
			'property' => 'background-color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'back_to_top_text_color',
	'label'       => esc_html__( 'BackToTop Text', 'industing' ),
	'description' => esc_html__( 'Insert your custom color for back to top button.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '#backtotop',
			'property' => 'color'
		],
	],
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'back_to_top_text_color_hover',
	'label'       => esc_html__( 'BackToTop Hover Text', 'industing' ),
	'description' => esc_html__( 'Insert your custom color for back to top button hover.', 'industing' ),
	'section'     => 'footer_styling',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '#backtotop:hover',
			'property' => 'color'
		],
	],
);
