<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Do not proceed if Kirki does not exist.
if ( ! class_exists( 'Kirki' ) ) {
	return;
}

Kirki::add_config( 'industing_customizer', array(
	'capability'  => 'edit_theme_options',
	'option_type' => 'theme_mod',
));


function industing_customizer_sections($wp_customize){
    $wp_customize->add_panel( 'theme_option', array(
        'priority'    => 10,
        'title'       => esc_attr__( 'Theme Options', 'industing' ),
    ) );

	$wp_customize->add_section( 'general_section', array(
		'title'			=> esc_html__( 'General Settings', 'industing' ),
		'priority'		=> 1,
		'description'           => esc_html__( 'to change logo,favicon etc', 'industing' ),
                'panel'                 => 'theme_option',
	) );

	$wp_customize->add_section( 'font_section', array(
		'title'			=> esc_html__( 'Typography Settings', 'industing' ),
		'priority'		=> 2,
		'description'           => esc_html__( 'Setup your site typography.', 'industing' ),
                'panel'                 => 'theme_option',
	));

	$wp_customize->add_section( 'colorpreset_section', array(
		'title'			=> esc_html__( 'Color Preset Settings', 'industing' ),
		'priority'		=> 3,
		'description'           => esc_html__( 'Setup your site accent color.', 'industing' ),
                'panel'                 => 'theme_option',
	));

	$wp_customize->add_section( 'header_settings', array(
		'title'			=> esc_html__( 'Header Settings', 'industing' ),
		'priority'		=> 4,
		'description'           => esc_html__( 'Setup your site header.', 'industing' ),
                'panel'                 => 'theme_option',
	) );
        
	$wp_customize->add_section( 'header_styling', array(
		'title'			=> esc_html__( 'Header Styling', 'industing' ),
		'priority'		=> 5,
		'description'           => esc_html__( 'Style up you site header.', 'industing' ),
                'panel'                 => 'theme_option',
	));
        
	$wp_customize->add_section( 'popup_styling', array(
		'title'			=> esc_html__( 'Popup Menu Styling', 'industing' ),
		'priority'		=> 6,
		'description'           => esc_html__( 'Style up you pupup menu.', 'industing' ),
                'panel'                 => 'theme_option',
	));

	$wp_customize->add_section( 'blog_settings', array(
		'title'			=> esc_html__( 'Blog Settings', 'industing' ),
		'priority'		=> 7,
		'description'           => esc_html__( 'Setup your blog pages.', 'industing' ),
                'panel'                 => 'theme_option',
	) );

	$wp_customize->add_section( 'single_blog_settings', array(
		'title'			=> esc_html__( 'Single Blog Settings', 'industing' ),
		'priority'		=> 8,
		'description'           => esc_html__( 'Setup your blog details pages.', 'industing' ),
                'panel'                 => 'theme_option',
	) );

	$wp_customize->add_section( 'service_page_settings', array(
		'title'			=> esc_html__( 'Service Listing', 'industing' ),
		'priority'		=> 10,
		'description'           => esc_html__( 'Setup your service listing page.', 'industing' ),
                'panel'                 => 'theme_option',
	) );

	$wp_customize->add_section( 'service_settings', array(
		'title'			=> esc_html__( 'Single Service', 'industing' ),
		'priority'		=> 11,
		'description'           => esc_html__( 'Setup your single service page.', 'industing' ),
                'panel'                 => 'theme_option',
	) );

	$wp_customize->add_section( 'folio_settings', array(
		'title'			=> esc_html__( 'Folio Settings', 'industing' ),
		'priority'		=> 12,
		'description'           => esc_html__( 'Setup your portfolio listing page.', 'industing' ),
                'panel'                 => 'theme_option',
	));

	$wp_customize->add_section( 'folio_single_settings', array(
		'title'			=> esc_html__( 'Folio Single Settings', 'industing' ),
		'priority'		=> 13,
		'description'           => esc_html__( 'Setup your portfolio details page.', 'industing' ),
                'panel'                 => 'theme_option',
	));

	$wp_customize->add_section( 'member_listing_settings', array(
		'title'			=> esc_html__( 'Member Listing Settings', 'industing' ),
		'priority'		=> 14,
		'description'           => esc_html__( 'Setup your member listing page.', 'industing' ),
                'panel'                 => 'theme_option',
	));

	$wp_customize->add_section( 'member_single_settings', array(
		'title'			=> esc_html__( 'Member Single Settings', 'industing' ),
		'priority'		=> 15,
		'description'           => esc_html__( 'Setup your member details page.', 'industing' ),
                'panel'                 => 'theme_option',
	));
	$wp_customize->add_section( 'shop_settings', array(
		'title'			=> esc_html__( 'Shop Settings', 'industing' ),
		'priority'		=> 16,
		'description'           => esc_html__( 'Setup your shop page.', 'industing' ),
                'panel'                 => 'theme_option',
	));
	$wp_customize->add_section( 'shop_single_settings', array(
		'title'			=> esc_html__( 'Product Single Settings', 'industing' ),
		'priority'		=> 16,
		'description'           => esc_html__( 'Setup your single product page.', 'industing' ),
                'panel'                 => 'theme_option',
	));

	$wp_customize->add_section( 'footer_settings', array(
		'title'			=> esc_html__( 'Footer Settings', 'industing' ),
		'priority'		=> 17,
		'description'           => esc_html__( 'Setup your site footer here.', 'industing' ),
                'panel'                 => 'theme_option',
	));

	$wp_customize->add_section( 'footer_styling', array(
		'title'			=> esc_html__( 'Footer Styling', 'industing' ),
		'priority'		=> 18,
		'description'           => esc_html__( 'Style your footer.', 'industing' ),
                'panel'                 => 'theme_option',
	));

	$wp_customize->add_section( 'social_section', array(
		'title'			=> esc_html__( 'Social Settings', 'industing' ),
		'priority'		=> 19,
		'description'           => esc_html__( 'Setup your social profile links.', 'industing' ),
                'panel'                 => 'theme_option',
	));

	$wp_customize->add_section( 'fof_section', array(
		'title'			=> esc_html__( '404 Settings', 'industing' ),
		'priority'		=> 20,
		'description'           => esc_html__( 'Setting up your 404 page.', 'industing' ),
                'panel'                 => 'theme_option',
	));
}

add_action( 'customize_register', 'industing_customizer_sections' );

require INDUSTING_CUSTOMIZER_DIR . 'customizer-fields.php' ;

