<?php
$bloks = array(
        'post_type'       => 'blocks',
        'post_status'     => 'publish',
        'posts_per_page'  => -1,
        'orderby'         => 'title',
        'order'           => 'ASC'
);
$all_bloks = array(
    'none' => esc_html__('None', 'industing')
);
$blok = new WP_Query($bloks);
if($blok->have_posts()):
    while($blok->have_posts()):
        $blok->the_post();
        $all_bloks[get_the_ID()] = get_the_title();
    endwhile;
endif;
wp_reset_postdata();

$fields[] = array(
        'type'        => 'image',
	'settings'    => 'blog_banner_bg',
	'label'       => esc_html__( 'Upload Banner BG', 'industing' ),
	'section'     => 'blog_settings',
	'default'     => '',
);

$fields[]= array(
        'type'        => 'color',
	'settings'    => 'blog_banner_overlay',
	'label'       => esc_html__( 'Banner Overlay Color', 'industing' ),
	'section'     => 'blog_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element'  => '.page_banner:after',
                        'property' => 'background'
		],
	],
);

$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'blog_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb', 'industing' ),
	'section'     => 'blog_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);

$fields[] = array(
        'type'          => 'text',
	'settings'      => 'blog_banner_title',
	'label'         => esc_html__( 'Banner Title', 'industing' ),
	'section'       => 'blog_settings',
	'default'       => esc_html__('Blog Posts', 'industing'),
        'transport'     => 'postMessage',
        'js_vars'       => array(
            array(
                'element'  => '.page_banner h2',
                'function' => 'html'
            ),
        ),
);

$fields[] = array(
        'type'          => 'text',
	'settings'      => 'blog_bread_title',
	'label'         => esc_html__( 'Breadcrumb Title', 'industing' ),
	'section'       => 'blog_settings',
	'default'       => esc_html__('Blog', 'industing'),
        'transport'     => 'postMessage',
        'js_vars'       => array(
            array(
                'element'  => '.breadcrumbs span',
                'function' => 'html'
            ),
        ),
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'blog_custom',
	'label'       => FALSE,
	'section'     => 'blog_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);


$fields[] = array(
        'type'        => 'select',
        'settings'    => 'blog_style',
        'label'       => esc_html__( 'Blog Style', 'industing' ),
        'section'     => 'blog_settings',
        'default'     => '1',
        'choices'     => array(
                '1'     => esc_html__( '1 Col', 'industing' ),
                '2'     => esc_html__( '2 Col', 'industing' ),
                '3'     => esc_html__( '3 Col', 'industing' )
        )
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'blog_sidebar',
        'label'       => esc_html__( 'Blog Sidebar Position', 'industing' ),
        'section'     => 'blog_settings',
        'default'     => '3',
        'choices'     => array(
                '1'      => esc_html__('Full Width','industing'),
                '2'      => esc_html__('Left Sidebar','industing'),
                '3'      => esc_html__('Right Sidebar','industing'),
        ),
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'blog_is_masonry',
	'label'       => esc_html__( 'Is Masonry', 'industing' ),
	'section'     => 'blog_settings',
	'default'     => '2',
	'choices'     => [
		'on'  => esc_html__( 'Yes', 'industing' ),
		'off' => esc_html__( 'No', 'industing' ),
	],
        'required'      => array( 
            array( 
                'setting'   => 'blog_style',
                'operator'  => '!=',
                'value'     => '1' 
            )
        ),
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'blog_pagi_align',
        'label'       => esc_html__( 'Pagination Alignment', 'industing' ),
        'section'     => 'blog_settings',
        'default'     => 'left',
        'choices'     => array(
                'left'      => esc_html__('Left','industing'),
                'center'      => esc_html__('Center','industing'),
                'right'      => esc_html__('Right','industing'),
        ),
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'blog_custom5',
	'label'       => FALSE,
	'section'     => 'blog_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[] = array(
    'type'              => 'repeater',
	'label'         => esc_html__( 'Add Blocks', 'industing' ),
	'section'       => 'blog_settings',
	'settings'      => 'blog_bloks',
	'row_label' => [
		'type'  => 'text',
		'value' => esc_html__('Block', 'industing' ),
	],
	'button_label' => esc_html__('Add New Block', 'industing' ),
	'default'      => [],
	'fields' => [
		'block_ids' => [
			'type'        => 'select',
                        'label'       => esc_html__( 'Block', 'industing' ),
                        'default'     => 'none',
                        'choices'     => $all_bloks
		]
	]
);