<?php
/**
 * archive.php
 *
 * The archive file.
 */
get_header();
get_template_part( 'template-parts/header/blog', 'header' );

$blog_style = get_theme_mod('blog_style', 1);
$blog_sidebar = get_theme_mod('blog_sidebar', 3);
$blog_is_masonry = get_theme_mod('blog_is_masonry', 2);
$blog_pagi_align = get_theme_mod('blog_pagi_align', 'left');

if($blog_sidebar == 1){
    if($blog_style == 1){
        $class = 'col-lg-10 offset-lg-1';
    }else{
        $class = 'col-lg-12';
    }
}else{
    $class = 'col-lg-8 col-sm-8 ';
}

if(!is_active_sidebar('sidebar-1')){
    $class = 'col-lg-12 ';
    $blog_sidebar = 1;
    $blog_style = 1;
}

$shuffle = '';
if($blog_style != 1 && $blog_is_masonry == 1){
    $shuffle = ' bloglistgrid ';
}
?>
<section class="commonSection newslistpage">
    <div class="container">
        <div class="row">
            <?php
            if ($blog_sidebar == 2 && is_active_sidebar('sidebar-1')) {
                get_sidebar();
            }
            ?>
            <div class="<?php echo esc_attr($class); ?>">
                <div class="row <?php echo esc_attr($shuffle); ?>">
                    <?php 
                        if($blog_style == 2 || $blog_style == 3):
                            while (have_posts()):
                                the_post(); 
                                get_template_part('template-parts/post/content', get_post_format()); 
                            endwhile; 
                        else:
                            while (have_posts()):
                                the_post(); 
                                get_template_part('template-parts/post/content-big', get_post_format()); 
                            endwhile; 
                        endif;
                    ?>
                    <div class="col-lg-12 col-sm-12 mt3">
                        <div class="ind_pagination text-<?php echo esc_attr($blog_pagi_align); ?>">
                            <?php 
                                the_posts_pagination( array(
                                    'prev_text' => '<i class="twi-arrow-left2"></i>',
                                    'next_text' =>  '<i class="twi-arrow-right2"></i>',
                                    'before_page_number' => '0'
                                ));
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            if ($blog_sidebar == 3 && is_active_sidebar('sidebar-1')) {
                get_sidebar();
            }
            ?>
        </div>
    </div>
</section>
<?php
    $blog_bloks = get_theme_mod('blog_bloks', '');
    $blocks_id = array();
    if(!empty($blog_bloks)){
        foreach($blog_bloks as $sb):
            if($sb['block_ids'] != '' && $sb['block_ids'] != 'none'):
                $blocks_id[] = $sb['block_ids'];
            endif;
        endforeach;
        $bloks = array(
            'post_type'     => 'blocks',
            'post_status'   => 'publish',
            'post__in'      => $blocks_id
        );
        $blok = new WP_Query($bloks);
        if($blok->have_posts()):
            while($blok->have_posts()):
            $blok->the_post();
            the_content();
            endwhile;
        endif;
    }
get_footer();