<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Section_Title_Widget extends Widget_Base {
    public function get_name() {
        return 'tw-section-title';
    }
    public function get_title() {
        return esc_html__('Section Title', 'themewar');
    }
    public function get_icon() {
        return 'eicon-t-letter';
    }
    public function get_categories() {
        return ['industing-elements'];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label'         =>esc_html__( 'Section Title', 'themewar' ),
            ]
        );
        $this->add_control(
                'sub_title', [
                    'label'             => esc_html__('Sub Title', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'label_block'       => TRUE,
                    'default'           => esc_html__('', 'themewar'),
                    'placeholder'       => esc_html__('Add Sub Title', 'themewar'),
                ]
        );
        $this->add_control(
                'section_title', [
                    'label'             => esc_html__('Section Title', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'label_block'       => TRUE,
                    'default'           => esc_html__('', 'themewar'),
                    'placeholder'       => esc_html__('Add Title', 'themewar'),
                ]
        );
        $this->add_control(
                'bg_icon',
                [
                        'label'         => esc_html__( 'Title Background Icon', 'themewar' ),
                        'type'          => Controls_Manager::ICON,
                        'label_block'   => TRUE
                ]
        );
        $this->add_control(
                'show_bar',
                [
                        'label'         => esc_html__( 'Title Bar', 'themewar' ),
                        'type'          => Controls_Manager::SWITCHER,
                        'label_on'      => esc_html__( 'Show', 'themewar' ),
                        'label_off'     => esc_html__( 'Hide', 'themewar' ),
                        'return_value'  => 'yes',
                        'default'       => 'yes'
                ]
        );
        $this->add_responsive_control(
                'section_title_align', [
                        'label'                     =>esc_html__( 'Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'		 => [
                                        'title'	 =>esc_html__( 'Left', 'themewar' ),
                                        'icon'	 => 'fa fa-align-left',
                                ],
                                'center'	 => [
                                        'title'	 =>esc_html__( 'Center', 'themewar' ),
                                        'icon'	 => 'fa fa-align-center',
                                ],
                                'right'		 => [
                                        'title'	 =>esc_html__( 'Right', 'themewar' ),
                                        'icon'	 => 'fa fa-align-right',
                                ]
                        ],
                        'default'                   => 'center',
                        'prefix_class'              => 'section_titles elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_1', [
                'label'         => esc_html__( 'Sub Title Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
                'sub_title_color', [
                        'label'		 =>esc_html__( 'Sub Title Color', 'themewar' ),
                        'type'		 => Controls_Manager::COLOR,
                        'selectors'	 => [
                            '{{WRAPPER}} .sub_title' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'sub_title_typography',
                        'label' => esc_html__( 'Sub Title Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .sub_title',
                ]
        );
        $this->add_control(
                'sub_title_margin',
                [
                        'label' => esc_html__( 'Marign', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .sub_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_2', [
                'label'         => esc_html__( 'Title Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
                'sec_title_color', [
                        'label'		 =>esc_html__( 'Title Color', 'themewar' ),
                        'type'		 => Controls_Manager::COLOR,
                        'selectors'	 => [
                            '{{WRAPPER}} .sec_title' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'sec_title_typography',
                        'label' => esc_html__( 'Title Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .sec_title',
                ]
        );
        $this->add_control(
                'sec_title_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .sec_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'sec_title_margin',
                [
                        'label' => esc_html__( 'Marign', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .sec_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'sec_icon_color', [
                        'label'		 =>esc_html__( 'Title Icon Color', 'themewar' ),
                        'type'		 => Controls_Manager::COLOR,
                        'selectors'	 => [
                            '{{WRAPPER}} .sec_title span i' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'sec_icon_typography',
                        'label' => esc_html__( 'Title Icon Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .sec_title span i',
                ]
        );
        $this->add_control(
                'sec_icon_margin',
                [
                        'label' => esc_html__( 'Icon Marign', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .sec_title span i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'sec_icon_padding',
                [
                        'label' => esc_html__( 'Icon Padding', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .sec_title span i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'width',
            [
                    'label' => __( 'Bar Width', 'themewar' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                            'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                    'step' => 1,
                            ],
                            '%' => [
                                    'min' => 0,
                                    'max' => 100,
                            ],
                    ],
                    'default' => [],
                    'selectors' => [
                            '{{WRAPPER}} .sec_title.with_bar:after' => 'width: {{SIZE}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
                'height',
                [
                        'label' => __( 'Bar Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .sec_title.with_bar:after' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'bar_bg',
                [
                        'label' => esc_html__( 'Bar BG Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .sec_title.with_bar:after' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->end_controls_section();
        
        
    }
    
    protected function render() {
        $settings       = $this->get_settings();
        $sub_title      = (isset($settings['sub_title']) && $settings['sub_title'] !='') ? $settings['sub_title'] : '';
        $section_title  = (isset($settings['section_title']) && $settings['section_title'] !='') ? $settings['section_title'] : '';
        $bg_icon        = (isset($settings['bg_icon']) && $settings['bg_icon'] != '') ? $settings['bg_icon'] : '';
        $show_bar       = (isset($settings['show_bar'])) ? $settings['show_bar'] : '';
        
        ?>
        <?php if($sub_title != ''): ?>
            <h6 class="sub_title"><?php echo esc_html($sub_title); ?></h6>
        <?php endif; ?>
        <?php if($section_title != ''): ?>
            <h2 class="sec_title <?php if($show_bar == 'yes'): echo 'with_bar'; endif; ?>">
                <?php if($bg_icon != ''): ?>
                <span><i class="<?php echo esc_attr($bg_icon); ?>"></i>
                    <span><?php echo wp_kses_post($section_title); ?></span>
                </span>
                <?php else: ?>
                    <span><?php echo wp_kses_post($section_title); ?></span>
                <?php endif; ?>
            </h2>
        <?php endif; ?>
        <?php
    }
    
    protected function _content_template() {
        
    }
}