<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_History_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-history';
    }
    
    public function get_title() {
        return esc_html__( 'History Section', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-date';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'History', 'themewar' ),
            ]
        );
       $repeater = new \Elementor\Repeater();
            $repeater->add_control(
                    'h_year',
                    [
                            'label'         => esc_html__( 'History Year', 'themewar' ),
                            'type'          => Controls_Manager::TEXT,
                            'default'       => '',
                            'label_block'   => true,
                            'placeholder'   => esc_html__('Insert Your Company History Year', 'themewar')
                    ]
            );
            $repeater->add_control(
                    'sub_title',
                    [
                            'label'         => esc_html__( 'History Sub Title', 'themewar' ),
                            'type'          => Controls_Manager::TEXT,
                            'default'       => '',
                            'label_block'   => true,
                            'placeholder'   => esc_html__('Insert Your History Sub Title', 'themewar')
                    ]
            );
            $repeater->add_control(
                    'title',
                    [
                            'label'         => esc_html__( 'History Title', 'themewar' ),
                            'type'          => Controls_Manager::TEXT,
                            'default'       => '',
                            'label_block'   => true,
                            'placeholder'   => esc_html__('Insert Your History Title', 'themewar')
                    ]
            );
            $repeater->add_control(
                    'desc',
                    [
                            'label'         => esc_html__( 'History Description', 'themewar' ),
                            'type'          => Controls_Manager::TEXTAREA,
                            'default'       => '',
                            'label_block'   => true,
                            'placeholder'   => esc_html__('Insert Your Company History Description', 'themewar')
                    ]
            );
            $repeater->add_control(
                'read_more',
                [
                        'label'         => esc_html__( 'Read More', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('', 'themewar'),
                        'description'   => esc_html__('Insert your Read More Label.', 'themewar'),
                ]
        );
        $repeater->add_control(
                'more_url',
                [
                        'label'             => esc_html__( 'Read More Url', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'show_external'     => true,
                        'default'           => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                        ],
                ]
        );
        $this->add_control(
            'list',
            [
                    'label'         => esc_html__( 'History List', 'themewar' ),
                    'type'          => Controls_Manager::REPEATER,
                    'fields'        => $repeater->get_controls(),
                    'default'       => [
                            [
                                    'h_year'                => esc_html__( '', 'themewar' ),
                                    'sub_title'             => esc_html__( '', 'themewar' ),
                                    'title'                 => esc_html__( '', 'themewar' ),
                                    'desc'                  => esc_html__( '', 'themewar' ),
                                    'read_more'             => esc_html__( '', 'themewar' ),
                                    'more_url'              => esc_html__( '', 'themewar' ),

                            ],
                    ],
                    'title_field' => '{{{ title }}}',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_1',
            [
                'label'     => esc_html__('History Year Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
                'year_color',
                [
                        'label' => esc_html__( 'Year Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .compay_date h2' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'year_typography',
                        'label' => esc_html__( 'Year Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .compay_date h2',
                ]
        );
        $this->add_control(
                'year_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .compay_date h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_2',
            [
                'label'     => esc_html__('Sub Title Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
                'sub_title_color',
                [
                        'label' => esc_html__( 'Sub Title Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .history_box span' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'sub_title_typography',
                        'label' => esc_html__( 'Sub Title Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .history_box span',
                ]
        );
        $this->add_control(
                'sub_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .history_box span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_3',
            [
                'label'     => esc_html__('Title Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
                'title_color',
                [
                        'label' => esc_html__( 'Title Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .history_box h3' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'title_typography',
                        'label' => esc_html__( 'Title Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .history_box h3',
                ]
        );
        $this->add_control(
                'title_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .history_box h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_4',
            [
                'label'     => esc_html__('Description Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
                'desc_color',
                [
                        'label' => esc_html__( 'Description Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .history_box p' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'desc_typography',
                        'label' => esc_html__( 'Description Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .history_box p',
                ]
        );
        $this->add_control(
                'desc_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .history_box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_5',
            [
                'label'     => esc_html__('Read More Label Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
                'label_color',
                [
                        'label' => esc_html__( 'Label Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .history_box a' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
                'label_hover_color',
                [
                        'label' => esc_html__( 'Label Hover Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .history_box a:hover' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'label_typography',
                        'label' => esc_html__( 'Label Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .history_box a',
                ]
        );
        $this->add_control(
                'label_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .history_box a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings           = $this->get_settings();
        $history            = (isset($settings['list']) && !empty($settings['list'])) ? $settings['list'] : array();
        
        if(!empty($history)):
            foreach($history as $item):
                $more_url       = (isset($item['more_url']['url'])) ? $item['more_url']['url'] : '';
                $title          = (isset($item['title'])) ? $item['title'] : '';
                $sub_title      = (isset($item['sub_title'])) ? $item['sub_title'] : '';
                $read_more      = (isset($item['read_more'])) ? $item['read_more'] : '';
                $desc           = (isset($item['desc'])) ? $item['desc'] : '';
                $h_year         = (isset($item['h_year'])) ? $item['h_year'] : '';
                ?>
                <div class="history_box">
                    <?php if($h_year != ''): ?><h5><?php echo esc_html($h_year); ?></h5><?php endif; ?>
                    <div class="hisbar"></div>
                    <?php if($sub_title != ''): ?><span><?php echo esc_html($sub_title); ?></span><?php endif; ?>
                    <?php if($title != ''): ?><h3><?php echo esc_html($title); ?></h3><?php endif; ?>
                    <?php if($desc != ''): ?>
                        <p>
                            <?php echo esc_html($desc); ?>
                        </p>
                    <?php endif; ?>
                    <?php if($read_more != ''): ?>
                        <a href="<?php echo esc_url($more_url); ?>"><?php echo esc_html($read_more); ?></a>
                    <?php endif; ?>
                </div>
                <?php
            endforeach;
        endif;
        
    }
    
    protected function _content_template() {
        
    }
}