<?php
$fargs = array(
    'post_type'         => 'folio',
    'post_status'       => 'publish',
    'posts_per_page'    => $portfolio_item,
    'orderby'           => $order_by,
    'order'             => $order
);

$folio = new WP_Query($fargs);
if($folio->have_posts()):
    ?>
    <?php if($is_filter == 'yes'): ?>
    <div class="row">
        <div class="col-sm-12">
            <div class="filterMenu">
                <?php 
                    $filter_cat = array(
                        'orderby'       => 'ID',
                        'order'         => 'DESC', 
                        'hide_empty'    => 1,
                        'hierarchical'  => 1,
                        'taxonomy'      => 'folio_cat'
                    );
                    $categories = get_categories( $filter_cat );
                    if(is_array($categories) && !empty($categories))
                    {
                        echo '<ul class="text-right clearfix shafful_filter">';
                            echo '<li class="all active" data-group="all"><i class="twi-bars2"></i>'.  esc_html__('All Cases', 'themewar').'</li>';
                            foreach($categories as $cat)
                            {
                                $folio_cate_icon = fw_get_db_term_option($cat->term_id, 'folio_cat', 'folio_cate_icon');
                                $ico_html = '';
                                if(isset($folio_cate_icon['type']) && $folio_cate_icon['type'] == 'icon-font'){
                                    $ico_html = '<i class="'.$folio_cate_icon['icon-class'].'"></i>';
                                }elseif(isset($folio_cate_icon['type']) && $folio_cate_icon['type'] == 'custom-upload'){
                                    $ico_html = '<img src="'.$folio_cate_icon['url'].'" alt="" class="icon_img" />';
                                }else{
                                    $ico_html = '';
                                }
                                echo '<li data-group="'.esc_attr($cat->slug).'">'.wp_kses_post($ico_html).esc_html($cat->name).'</li>';
                            }
                        echo '</ul>';
                    }
                    
                ?>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <div class="row" id="shafulls">
    <?php
        $filterClass = '';
        if($folio_style == '1'){
            $filterClass = 'shaf_itme';
        }
        
        while($folio->have_posts()):
            $folio->the_post();

            $data_groups = '["all", ';
            $terms = get_the_terms(get_the_ID(), 'folio_cat');
            $cats = '';
            $classes = '';
            if (is_array($terms) && !empty($terms)) 
            {
                $p = 1;
                $c = count($terms);
                foreach ($terms as $term) 
                {
                    if($p == $c)
                    {
                        $cats .= '<a  class="cate" href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                        if($folio_style == '1'):
                            $data_groups .= '"'.$term->slug.'"';
                        endif;
                    }
                    else
                    {
                        $cats .= '<a  class="cate" href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>, ';
                        if($folio_style == '1'):
                            $data_groups .= '"'.$term->slug.'", ';
                        endif;
                    }
                    $classes .= $term->slug.' ';
                    $p++;
                }
            }
            $data_groups .= ']';
            ?>
            <div class="col-lg-4 col-sm-6 <?php echo esc_attr($filterClass); ?>"  data-groups="<?php echo esc_attr($data_groups); ?>">
                <div class="singlefolio">
                    <?php if(has_post_thumbnail()): ?>
                        <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-folio-1'); ?>
                    <?php else: ?>
                        <img src="https://via.placeholder.com/370x290.jpg" alt="<?php echo get_the_title(); ?>">
                    <?php endif; ?>
                    <div class="folioHover">
                        <p><?php echo wp_kses_post($cats); ?></p>
                        <h4><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h4>
                    </div>
                </div>
            </div>
            <?php
        endwhile;
    ?>
    </div>
    <?php
endif;
wp_reset_postdata();